/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.renderer.task;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.log.Logger;
import net.pl3x.map.core.markers.JsonObjectWrapper;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.scheduler.Task;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class AbstractDataTask
extends Task {
    protected final Gson gson = new GsonBuilder().disableHtmlEscaping().serializeNulls().setLenient().registerTypeHierarchyAdapter(Marker.class, (Object)new Adapter()).create();
    protected final World world;
    protected final Map<String, Long> lastUpdated = new HashMap<String, Long>();
    protected final ExecutorService executor;
    protected final String executorName;
    protected CompletableFuture<Void> future;
    protected boolean running;

    public AbstractDataTask(int delay, boolean repeat, World world, String serviceName, int threads) {
        super(delay, repeat);
        this.world = world;
        this.executor = Pl3xMap.ThreadFactory.createService(serviceName, threads);
        this.executorName = serviceName;
    }

    public AbstractDataTask(int delay, boolean repeat, World world, String serviceName) {
        super(delay, repeat);
        this.world = world;
        this.executor = Pl3xMap.ThreadFactory.createService(serviceName);
        this.executorName = serviceName;
    }

    @Override
    public void run() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.future = CompletableFuture.runAsync(() -> {
            try {
                this.parse();
            }
            catch (Throwable t) {
                Logger.severe("Failed to parse task %s for world %s".formatted(this.executorName, this.world.getName()), t);
            }
            this.running = false;
        }, this.executor);
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.future != null) {
            this.future.cancel(true);
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public abstract void parse();

    protected static class Adapter
    implements JsonSerializer<Marker<?>> {
        protected Adapter() {
        }

        public JsonElement serialize(Marker<?> marker, Type type, JsonSerializationContext context) {
            JsonObjectWrapper wrapper = new JsonObjectWrapper();
            wrapper.addProperty("type", marker.getType());
            wrapper.addProperty("data", marker);
            wrapper.addProperty("options", marker.getOptions());
            return wrapper.getJsonObject();
        }
    }
}

