/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.renderer.task;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.log.Logger;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.util.Mathf;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class RegionDoubleChecker
implements Runnable {
    private final Executor executor = Pl3xMap.ThreadFactory.createService("Pl3xMap-DoubleChecker");
    private CompletableFuture<Void> future;
    private boolean running;

    public void start(long delay) {
        if (this.future != null) {
            Logger.debug("Region double checker executor already scheduled!");
            return;
        }
        Logger.debug("Scheduled region double checker executor");
        this.future = CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Logger.debug("Region double checker starting run at " + System.currentTimeMillis());
            this.run();
            Logger.debug("Region double checker finished run at " + System.currentTimeMillis());
            this.future = null;
            this.start(30000L);
        }, this.executor);
    }

    public void stop() {
        if (this.future != null) {
            boolean result = this.future.cancel(true);
            this.future = null;
            Logger.debug("Stopped region double checker executor: " + result);
        }
    }

    @Override
    public void run() {
        if (this.running) {
            Logger.debug("Region processor already running!");
            return;
        }
        this.running = true;
        try {
            Pl3xMap.api().getWorldRegistry().forEach(world -> {
                if (!world.isEnabled()) {
                    return;
                }
                Collection<Path> files = world.getRegionFiles();
                HashSet<Point> modifiedRegions = new HashSet<Point>();
                for (Path file : files) {
                    try {
                        long modified;
                        String[] split = file.getFileName().toString().split("\\.");
                        int rX = Integer.parseInt(split[1]);
                        int rZ = Integer.parseInt(split[2]);
                        if (!world.visibleRegion(rX, rZ)) {
                            Logger.debug("Skipping region outside of visible areas: " + String.valueOf(file.getFileName()));
                            continue;
                        }
                        long state = world.getRegionModifiedState().get(Mathf.asLong(rX, rZ));
                        if (state >= (modified = Files.getLastModifiedTime(file, new LinkOption[0]).toMillis())) continue;
                        Logger.debug("Found modified region: " + String.valueOf(file.getFileName()));
                        modifiedRegions.add(Point.of(rX, rZ));
                    }
                    catch (Throwable t) {
                        Logger.severe("Failed while trying to parse region file %s".formatted(file.toAbsolutePath()), t);
                    }
                }
                Pl3xMap.api().getRegionProcessor().addRegions((World)world, (Collection<Point>)modifiedRegions);
            });
        }
        catch (Throwable t) {
            Logger.severe("Failed to loop through region files for worlds", t);
        }
        this.running = false;
    }
}

