/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.renderer.task;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.pl3x.map.core.log.Logger;
import net.pl3x.map.core.markers.layer.Layer;
import net.pl3x.map.core.renderer.task.AbstractDataTask;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class UpdateLiveData
extends AbstractDataTask {
    private final Cache<String, Integer> markerCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private Map<String, CompletableFuture<Void>> liveUpdateFutures = new HashMap<String, CompletableFuture<Void>>();

    public UpdateLiveData(World world, int threads) {
        super(1, true, world, "Pl3xMap-LiveData", threads);
    }

    @Override
    public void cancel() {
        super.cancel();
        this.liveUpdateFutures.forEach((key, future) -> future.cancel(true));
        this.liveUpdateFutures.clear();
    }

    @Override
    public void parse() {
        this.world.getLayerRegistry().entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            Layer layer = (Layer)entry.getValue();
            if (!layer.isLiveUpdate()) {
                return;
            }
            CompletableFuture<Void> future = this.liveUpdateFutures.get(key);
            if (future != null && !future.isDone()) {
                return;
            }
            this.liveUpdateFutures.put(key, CompletableFuture.runAsync(() -> {
                try {
                    ArrayList list = new ArrayList(layer.getMarkers());
                    Integer markerCacheIfPresent = (Integer)this.markerCache.getIfPresent((Object)key);
                    int markerHashCode = list.hashCode();
                    if (markerCacheIfPresent == null || !markerCacheIfPresent.equals(markerHashCode)) {
                        Logger.debug("[%s/%s] sending through sse %d".formatted(this.world.getName(), key, System.currentTimeMillis()));
                        this.world.getServerSentEventHandler().send("markers", String.format("{\"key\": \"%s\", \"markers\": %s}", key, this.gson.toJson(list)));
                        this.markerCache.put((Object)key, (Object)markerHashCode);
                    }
                }
                catch (Throwable t) {
                    Logger.debug("[%s/%s] failed".formatted(this.world.getName(), key));
                    t.printStackTrace();
                }
                finally {
                    this.liveUpdateFutures.remove(key);
                }
            }, this.executor));
        });
    }
}

