/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.util;

import net.pl3x.map.core.markers.Point;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class Mathf {
    public static float lerp(float a2, float b2, float t) {
        return a2 + t * (b2 - a2);
    }

    public static float inverseLerp(float a2, float b2, float t) {
        return (t - a2) / (b2 - a2);
    }

    public static double clamp(double min, double max, double value) {
        return Math.min(Math.max(value, min), max);
    }

    public static float clamp(float min, float max, float value) {
        return Math.min(Math.max(value, min), max);
    }

    public static int clamp(int min, int max, int value) {
        return Math.min(Math.max(value, min), max);
    }

    public static int distanceSquared(int x1, int z1, int x2, int z2) {
        return Mathf.square(x1 - x2) + Mathf.square(z1 - z2);
    }

    public static int square(int n) {
        return n * n;
    }

    public static int pow2(int value) {
        return 1 << value;
    }

    public static long asLong(Point pos) {
        return Mathf.asLong(pos.x(), pos.z());
    }

    public static long asLong(long x, long z) {
        return x & 0xFFFFFFFFL | (z & 0xFFFFFFFFL) << 32;
    }

    public static int longToX(long pos) {
        return (int)(pos & 0xFFFFFFFFL);
    }

    public static int longToZ(long pos) {
        return (int)(pos >>> 32 & 0xFFFFFFFFL);
    }
}

