/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.world;

import java.util.Arrays;
import net.pl3x.map.core.world.Biome;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class LegacyBiomes {
    private static final Biome[] BIOME_IDS = new Biome[174];

    private static Biome create(String id, float temperature, float humidity, int color, int foliage, int grass, int water) {
        return new Biome(0, id, color, 10387789, foliage, grass, water, (x, z, def) -> def);
    }

    public static @Nullable Biome get(int legacyId) {
        if (legacyId < 0 || legacyId >= BIOME_IDS.length) {
            legacyId = 0;
        }
        return BIOME_IDS[legacyId];
    }

    static {
        Arrays.fill(BIOME_IDS, Biome.DEFAULT);
        LegacyBiomes.BIOME_IDS[0] = LegacyBiomes.create("minecraft:ocean", 0.5f, 0.5f, 112, 7579470, 9353585, 4159204);
        LegacyBiomes.BIOME_IDS[1] = LegacyBiomes.create("minecraft:plains", 0.8f, 0.4f, 9286496, 7580464, 9551193, 4159204);
        LegacyBiomes.BIOME_IDS[2] = LegacyBiomes.create("minecraft:desert", 2.0f, 0.0f, 16421912, 11117868, 12564309, 4159204);
        LegacyBiomes.BIOME_IDS[3] = LegacyBiomes.create("minecraft:mountains", 0.2f, 0.3f, 0x606060, 7119725, 9090697, 4159204);
        LegacyBiomes.BIOME_IDS[4] = LegacyBiomes.create("minecraft:forest", 0.7f, 0.8f, 353825, 5877552, 7979098, 4159204);
        LegacyBiomes.BIOME_IDS[5] = LegacyBiomes.create("minecraft:taiga", 0.25f, 0.8f, 747097, 6857827, 8828803, 4159204);
        LegacyBiomes.BIOME_IDS[6] = LegacyBiomes.create("minecraft:swamp", 0.8f, 0.9f, 522674, 4502818, 6997070, 6388580);
        LegacyBiomes.BIOME_IDS[7] = LegacyBiomes.create("minecraft:river", 0.5f, 0.5f, 255, 7579470, 9353585, 4159204);
        LegacyBiomes.BIOME_IDS[8] = LegacyBiomes.create("minecraft:nether", 2.0f, 0.0f, 0xBF3B3B, 11117868, 12564309, 4159204);
        LegacyBiomes.BIOME_IDS[9] = LegacyBiomes.create("minecraft:the_end", 0.5f, 0.5f, 0x8080FF, 7579470, 9353585, 4159204);
        LegacyBiomes.BIOME_IDS[10] = LegacyBiomes.create("minecraft:frozen_ocean", 0.0f, 0.5f, 7368918, 6529656, 8434839, 3750089);
        LegacyBiomes.BIOME_IDS[11] = LegacyBiomes.create("minecraft:frozen_river", 0.0f, 0.5f, 0xA0A0FF, 6529656, 8434839, 3750089);
        LegacyBiomes.BIOME_IDS[12] = LegacyBiomes.create("minecraft:snowy_tundra", 0.0f, 0.5f, 0xFFFFFF, 6529656, 8434839, 4159204);
        LegacyBiomes.BIOME_IDS[13] = LegacyBiomes.create("minecraft:snowy_mountains", 0.0f, 0.5f, 0xA0A0A0, 6529656, 8434839, 4159204);
        LegacyBiomes.BIOME_IDS[14] = LegacyBiomes.create("minecraft:mushroom_fields", 0.9f, 1.0f, 0xFF00FF, 3062538, 5622079, 4159204);
        LegacyBiomes.BIOME_IDS[15] = LegacyBiomes.create("minecraft:mushroom_field_shore", 0.9f, 1.0f, 0xA000FF, 3062538, 5622079, 4159204);
        LegacyBiomes.BIOME_IDS[16] = LegacyBiomes.create("minecraft:beach", 0.8f, 0.4f, 16440917, 7580464, 9551193, 4159204);
        LegacyBiomes.BIOME_IDS[17] = LegacyBiomes.create("minecraft:desert_hills", 2.0f, 0.0f, 13786898, 11117868, 12564309, 4159204);
        LegacyBiomes.BIOME_IDS[18] = LegacyBiomes.create("minecraft:wooded_hills", 0.7f, 0.8f, 2250012, 5877552, 7979098, 4159204);
        LegacyBiomes.BIOME_IDS[19] = LegacyBiomes.create("minecraft:taiga_hills", 0.25f, 0.8f, 1456435, 6857827, 8828803, 4159204);
        LegacyBiomes.BIOME_IDS[20] = LegacyBiomes.create("minecraft:mountain_edge", 0.2f, 0.3f, 7501978, 7119725, 9090697, 4159204);
        LegacyBiomes.BIOME_IDS[21] = LegacyBiomes.create("minecraft:jungle", 0.95f, 0.9f, 5470985, 3062538, 5884220, 4159204);
        LegacyBiomes.BIOME_IDS[22] = LegacyBiomes.create("minecraft:jungle_hills", 0.95f, 0.9f, 2900485, 3062538, 5884220, 4159204);
        LegacyBiomes.BIOME_IDS[23] = LegacyBiomes.create("minecraft:jungle_edge", 0.95f, 0.8f, 6458135, 4437775, 6604607, 4159204);
        LegacyBiomes.BIOME_IDS[24] = LegacyBiomes.create("minecraft:deep_ocean", 0.5f, 0.5f, 48, 7579470, 9353585, 4159204);
        LegacyBiomes.BIOME_IDS[25] = LegacyBiomes.create("minecraft:stone_shore", 0.2f, 0.3f, 10658436, 7119725, 9090697, 4159204);
        LegacyBiomes.BIOME_IDS[26] = LegacyBiomes.create("minecraft:snowy_beach", 0.05f, 0.3f, 16445632, 6529656, 8631699, 4020182);
        LegacyBiomes.BIOME_IDS[27] = LegacyBiomes.create("minecraft:birch_forest", 0.6f, 0.6f, 3175492, 7055681, 0x88BB66, 4159204);
        LegacyBiomes.BIOME_IDS[28] = LegacyBiomes.create("minecraft:birch_forest_hills", 0.6f, 0.6f, 2055986, 7055681, 0x88BB66, 4159204);
        LegacyBiomes.BIOME_IDS[29] = LegacyBiomes.create("minecraft:dark_forest", 0.7f, 0.8f, 4215066, 5877552, 7979098, 4159204);
        LegacyBiomes.BIOME_IDS[30] = LegacyBiomes.create("minecraft:snowy_taiga", -0.5f, 0.4f, 3233098, 6529656, 8434839, 4020182);
        LegacyBiomes.BIOME_IDS[31] = LegacyBiomes.create("minecraft:snowy_taiga_hills", -0.5f, 0.4f, 2375478, 6529656, 8434839, 4020182);
        LegacyBiomes.BIOME_IDS[32] = LegacyBiomes.create("minecraft:giant_tree_taiga", 0.3f, 0.8f, 5858897, 6792543, 8829055, 4159204);
        LegacyBiomes.BIOME_IDS[33] = LegacyBiomes.create("minecraft:giant_tree_taiga_hills", 0.3f, 0.8f, 4542270, 6792543, 8829055, 4159204);
        LegacyBiomes.BIOME_IDS[34] = LegacyBiomes.create("minecraft:wooded_mountains", 0.2f, 0.3f, 0x507050, 7119725, 9090697, 4159204);
        LegacyBiomes.BIOME_IDS[35] = LegacyBiomes.create("minecraft:savanna", 2.0f, 0.0f, 12431967, 11117868, 12564309, 4159204);
        LegacyBiomes.BIOME_IDS[36] = LegacyBiomes.create("minecraft:savanna_plateau", 2.0f, 0.0f, 10984804, 11117868, 12564309, 4159204);
        LegacyBiomes.BIOME_IDS[37] = LegacyBiomes.create("minecraft:badlands", 2.0f, 0.0f, 14238997, 11117868, 12564309, 4159204);
        LegacyBiomes.BIOME_IDS[38] = LegacyBiomes.create("minecraft:wooded_badlands_plateau", 2.0f, 0.0f, 11573093, 11117868, 12564309, 4159204);
        LegacyBiomes.BIOME_IDS[39] = LegacyBiomes.create("minecraft:badlands_plateau", 2.0f, 0.0f, 13274213, 11117868, 12564309, 4159204);
        LegacyBiomes.BIOME_IDS[40] = LegacyBiomes.create("minecraft:small_end_islands", 0.5f, 0.5f, 42, 7579470, 9353585, 4159204);
        LegacyBiomes.BIOME_IDS[41] = LegacyBiomes.create("minecraft:end_midlands", 0.5f, 0.5f, 15464630, 7579470, 9353585, 4159204);
        LegacyBiomes.BIOME_IDS[42] = LegacyBiomes.create("minecraft:end_highlands", 0.5f, 0.5f, 12828041, 7579470, 9353585, 4159204);
        LegacyBiomes.BIOME_IDS[43] = LegacyBiomes.create("minecraft:end_barrens", 0.5f, 0.5f, 9474162, 7579470, 9353585, 4159204);
        LegacyBiomes.BIOME_IDS[44] = LegacyBiomes.create("minecraft:warm_ocean", 0.5f, 0.5f, 172, 7579470, 9353585, 4445678);
        LegacyBiomes.BIOME_IDS[45] = LegacyBiomes.create("minecraft:lukewarm_ocean", 0.5f, 0.5f, 144, 7579470, 9353585, 4566514);
        LegacyBiomes.BIOME_IDS[46] = LegacyBiomes.create("minecraft:cold_ocean", 0.5f, 0.5f, 0x202070, 7579470, 9353585, 4020182);
        LegacyBiomes.BIOME_IDS[47] = LegacyBiomes.create("minecraft:deep_warm_ocean", 0.5f, 0.5f, 80, 7579470, 9353585, 4445678);
        LegacyBiomes.BIOME_IDS[48] = LegacyBiomes.create("minecraft:deep_lukewarm_ocean", 0.5f, 0.5f, 64, 7579470, 9353585, 4566514);
        LegacyBiomes.BIOME_IDS[49] = LegacyBiomes.create("minecraft:deep_cold_ocean", 0.5f, 0.5f, 2105400, 7579470, 9353585, 4020182);
        LegacyBiomes.BIOME_IDS[50] = LegacyBiomes.create("minecraft:deep_frozen_ocean", 0.5f, 0.5f, 0x404090, 7579470, 9353585, 3750089);
        LegacyBiomes.BIOME_IDS[127] = LegacyBiomes.create("minecraft:the_void", 0.5f, 0.5f, 0, 7579470, 9353585, 4159204);
        LegacyBiomes.BIOME_IDS[129] = LegacyBiomes.create("minecraft:sunflower_plains", 0.8f, 0.4f, 11918216, 7580464, 9551193, 4159204);
        LegacyBiomes.BIOME_IDS[130] = LegacyBiomes.create("minecraft:desert_lakes", 2.0f, 0.0f, 16759872, 11117868, 12564309, 4159204);
        LegacyBiomes.BIOME_IDS[131] = LegacyBiomes.create("minecraft:gravelly_mountains", 0.2f, 0.3f, 0x888888, 7119725, 9090697, 4159204);
        LegacyBiomes.BIOME_IDS[132] = LegacyBiomes.create("minecraft:flower_forest", 0.7f, 0.8f, 2985545, 5877552, 7979098, 4159204);
        LegacyBiomes.BIOME_IDS[133] = LegacyBiomes.create("minecraft:taiga_mountains", 0.25f, 0.8f, 3378817, 6857827, 8828803, 4159204);
        LegacyBiomes.BIOME_IDS[134] = LegacyBiomes.create("minecraft:swamp_hills", 0.8f, 0.9f, 3145690, 4502818, 6997070, 6388580);
        LegacyBiomes.BIOME_IDS[140] = LegacyBiomes.create("minecraft:ice_spikes", 0.0f, 0.5f, 11853020, 6529656, 8434839, 4159204);
        LegacyBiomes.BIOME_IDS[149] = LegacyBiomes.create("minecraft:modified_jungle", 0.95f, 0.9f, 8102705, 3062538, 5884220, 4159204);
        LegacyBiomes.BIOME_IDS[151] = LegacyBiomes.create("minecraft:modified_jungle_edge", 0.95f, 0.8f, 9089855, 4437775, 6604607, 4159204);
        LegacyBiomes.BIOME_IDS[155] = LegacyBiomes.create("minecraft:tall_birch_forest", 0.6f, 0.6f, 5807212, 7055681, 0x88BB66, 4159204);
        LegacyBiomes.BIOME_IDS[156] = LegacyBiomes.create("minecraft:tall_birch_hills", 0.6f, 0.6f, 4687706, 7055681, 0x88BB66, 4159204);
        LegacyBiomes.BIOME_IDS[157] = LegacyBiomes.create("minecraft:dark_forest_hills", 0.7f, 0.8f, 6846786, 5877552, 7979098, 4159204);
        LegacyBiomes.BIOME_IDS[158] = LegacyBiomes.create("minecraft:snowy_taiga_mountains", -0.5f, 0.4f, 5864818, 6529656, 8434839, 4020182);
        LegacyBiomes.BIOME_IDS[160] = LegacyBiomes.create("minecraft:giant_spruce_taiga", 0.25f, 0.8f, 8490617, 6857827, 8828803, 4159204);
        LegacyBiomes.BIOME_IDS[161] = LegacyBiomes.create("minecraft:giant_spruce_taiga_hills", 0.25f, 0.8f, 0x6D7766, 6857827, 8828803, 4159204);
        LegacyBiomes.BIOME_IDS[162] = LegacyBiomes.create("minecraft:modified_gravelly_mountains", 0.2f, 0.3f, 0x789878, 7119725, 9090697, 4159204);
        LegacyBiomes.BIOME_IDS[163] = LegacyBiomes.create("minecraft:shattered_savanna", 1.1f, 0.0f, 15063687, 11117868, 12564309, 4159204);
        LegacyBiomes.BIOME_IDS[164] = LegacyBiomes.create("minecraft:shattered_savanna_plateau", 1.0f, 0.0f, 13616524, 11117868, 12564309, 4159204);
        LegacyBiomes.BIOME_IDS[165] = LegacyBiomes.create("minecraft:eroded_badlands", 2.0f, 0.0f, 16739645, 11117868, 12564309, 4159204);
        LegacyBiomes.BIOME_IDS[166] = LegacyBiomes.create("minecraft:modified_wooded_badlands_plateau", 2.0f, 0.0f, 14204813, 11117868, 12564309, 4159204);
        LegacyBiomes.BIOME_IDS[167] = LegacyBiomes.create("minecraft:modified_badlands_plateau", 2.0f, 0.0f, 15905933, 11117868, 12564309, 4159204);
        LegacyBiomes.BIOME_IDS[168] = LegacyBiomes.create("minecraft:bamboo_jungle", 0.95f, 0.9f, 7769620, 2066695, 5884220, 4159204);
        LegacyBiomes.BIOME_IDS[169] = LegacyBiomes.create("minecraft:bamboo_jungle_hills", 0.95f, 0.9f, 3884810, 2066695, 5884220, 4159204);
        LegacyBiomes.BIOME_IDS[170] = LegacyBiomes.create("minecraft:soul_sand_valley", 2.0f, 0.0f, 6174768, 11117868, 12564309, 4159204);
        LegacyBiomes.BIOME_IDS[171] = LegacyBiomes.create("minecraft:crimson_forest", 2.0f, 0.0f, 0xDD0808, 11117868, 12564309, 4159204);
        LegacyBiomes.BIOME_IDS[172] = LegacyBiomes.create("minecraft:warped_forest", 2.0f, 0.0f, 4821115, 11117868, 12564309, 4159204);
        LegacyBiomes.BIOME_IDS[173] = LegacyBiomes.create("minecraft:basalt_deltas", 2.0f, 0.0f, 4208182, 11117868, 12564309, 4159204);
    }
}

