/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.fabric.client.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.image.BufferedImage;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_10093;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_22;
import net.minecraft.class_3620;
import net.minecraft.class_8710;
import net.pl3x.map.core.util.Colors;
import net.pl3x.map.fabric.client.Pl3xMapFabricClient;
import net.pl3x.map.fabric.client.duck.MapInstance;
import net.pl3x.map.fabric.common.network.ServerboundMapPayload;
import org.jspecify.annotations.NullMarked;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@NullMarked
@Mixin(value={class_10093.class_331.class})
public abstract class MapInstanceMixin
implements MapInstance {
    @Final
    @Shadow
    class_1043 field_2048;
    @Shadow
    class_22 field_2046;
    @Shadow
    boolean field_34044;
    @Unique
    private final BufferedImage image = new BufferedImage(128, 128, 2);
    @Unique
    private Pl3xMapFabricClient mod;
    @Unique
    private int id;
    @Unique
    private byte scale;
    @Unique
    private int centerX;
    @Unique
    private int centerZ;
    @Unique
    private String world;
    @Unique
    private boolean isReady;
    @Unique
    private boolean skip;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void ctor(class_10093 renderer, int id, class_22 data, CallbackInfo ci) {
        this.mod = Pl3xMapFabricClient.getInstance();
        this.id = id;
    }

    @Inject(method={"updateTextureIfNeeded()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void updateTextureIfNeeded(CallbackInfo ci) {
        if (!this.mod.isEnabled()) {
            return;
        }
        if (!this.mod.isOnServer()) {
            return;
        }
        if (this.mod.getServerUrl() == null) {
            return;
        }
        if (this.skip) {
            return;
        }
        if (!this.isReady) {
            ClientPlayNetworking.send((class_8710)new ServerboundMapPayload(this.id));
            this.skip = true;
            return;
        }
        if (this.updateMapTexture()) {
            ci.cancel();
        }
    }

    @Override
    public void pl3xMap$skip() {
        this.isReady = true;
        this.skip = true;
    }

    @Override
    public void pl3xMap$setData(byte scale, int centerX, int centerZ, String world) {
        this.scale = scale;
        this.centerX = centerX;
        this.centerZ = centerZ;
        this.world = world;
        this.isReady = true;
        this.skip = false;
        this.pl3xMap$updateImage();
    }

    @Override
    public void pl3xMap$updateImage() {
        if (RenderSystem.isOnRenderThread()) {
            this.mod.getExecutor().submit(this::pl3xMap$updateImage);
            return;
        }
        if (!this.isReady) {
            return;
        }
        int mod = 1 << this.scale;
        int startX = (this.centerX / mod - 64) * mod;
        int startZ = (this.centerZ / mod - 64) * mod;
        for (int x = 0; x < 128; ++x) {
            for (int z = 0; z < 128; ++z) {
                int blockX = startX + x * mod + this.scale;
                int blockZ = startZ + z * mod + this.scale;
                BufferedImage img = this.mod.getTileManager().get(this.world, blockX >> 9, blockZ >> 9);
                this.image.setRGB(x, z, Colors.rgb2bgr(img.getRGB(blockX & 0x1FF, blockZ & 0x1FF)));
            }
        }
        this.field_34044 = true;
    }

    @Unique
    private boolean updateMapTexture() {
        class_1011 pixels = this.field_2048.method_4525();
        if (pixels == null) {
            return false;
        }
        for (int x = 0; x < 128; ++x) {
            for (int z = 0; z < 128; ++z) {
                int color = this.field_2046.field_122[x + z * 128] & 0xFF;
                if (color >> 2 == 0) {
                    pixels.method_61941(x, z, 0);
                    continue;
                }
                int pl3xColor = this.image.getRGB(x, z);
                if (pl3xColor == 0) {
                    pixels.method_61941(x, z, class_3620.method_38480((int)color));
                    continue;
                }
                pixels.method_61941(x, z, pl3xColor);
            }
        }
        this.field_2048.method_4524();
        return true;
    }
}

