/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.description;

import java.util.Objects;
import libs.org.checkerframework.checker.nullness.qual.NonNull;
import org.apiguardian.api.API;
import org.immutables.value.Value;
import org.incendo.cloud.description.DescriptionImpl;

@API(status=API.Status.STABLE)
@Value.Immutable
public interface Description {
    public static final Description EMPTY = DescriptionImpl.of("");

    public static @NonNull Description empty() {
        return EMPTY;
    }

    public static @NonNull Description of(@NonNull String string) {
        if (Objects.requireNonNull(string, "string").isEmpty()) {
            return Description.empty();
        }
        return DescriptionImpl.of(string);
    }

    public static @NonNull Description description(@NonNull String string) {
        return Description.of(string);
    }

    public @NonNull String textDescription();

    default public boolean isEmpty() {
        return this.textDescription().isEmpty();
    }
}

