/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.exception.parsing;

import java.util.Objects;
import libs.org.checkerframework.checker.nullness.qual.NonNull;
import org.apiguardian.api.API;
import org.incendo.cloud.caption.CaptionVariable;
import org.incendo.cloud.caption.StandardCaptionKeys;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.exception.parsing.ParserException;
import org.incendo.cloud.parser.standard.NumberParser;
import org.incendo.cloud.type.range.Range;

@API(status=API.Status.STABLE)
public abstract class NumberParseException
extends ParserException {
    private final String input;
    private final NumberParser<?, ?, ?> parser;

    protected NumberParseException(@NonNull String input, @NonNull NumberParser<?, ?, ?> parser, @NonNull CommandContext<?> context) {
        super(parser.getClass(), context, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_NUMBER, CaptionVariable.of("input", input), CaptionVariable.of("min", String.valueOf(parser.range().min())), CaptionVariable.of("max", String.valueOf(parser.range().max())));
        this.input = input;
        this.parser = parser;
    }

    public abstract @NonNull String numberType();

    public final @NonNull NumberParser<?, ?, ?> parser() {
        return this.parser;
    }

    public final boolean hasMax() {
        return this.parser.hasMax();
    }

    public final boolean hasMin() {
        return this.parser.hasMax();
    }

    public @NonNull String input() {
        return this.input;
    }

    public final @NonNull Range<? extends Number> range() {
        return this.parser.range();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumberParseException that = (NumberParseException)o;
        return this.parser().equals(that.parser());
    }

    public final int hashCode() {
        return Objects.hash(this.parser());
    }
}

