/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.attribute;

import libs.io.undertow.attribute.ExchangeAttribute;
import libs.io.undertow.attribute.ExchangeAttributeBuilder;
import libs.io.undertow.attribute.ReadOnlyAttributeException;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.server.handlers.Cookie;
import libs.io.undertow.server.handlers.CookieImpl;

public class CookieAttribute
implements ExchangeAttribute {
    private final String cookieName;

    public CookieAttribute(String cookieName) {
        this.cookieName = cookieName;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        for (Cookie cookie : exchange.requestCookies()) {
            if (!this.cookieName.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        exchange.setResponseCookie(new CookieImpl(this.cookieName, newValue));
    }

    public String toString() {
        return "%{c," + this.cookieName + "}";
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Cookie";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.startsWith("%{c,") && token.endsWith("}")) {
                String cookieName = token.substring(4, token.length() - 1);
                return new CookieAttribute(cookieName);
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

