/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.attribute;

import libs.io.undertow.attribute.ExchangeAttribute;
import libs.io.undertow.attribute.ExchangeAttributeBuilder;
import libs.io.undertow.attribute.ReadOnlyAttributeException;
import libs.io.undertow.server.HttpServerExchange;

public class HostAndPortAttribute
implements ExchangeAttribute {
    public static final String HOST_AND_PORT = "%{HOST_AND_PORT}";
    public static final ExchangeAttribute INSTANCE = new HostAndPortAttribute();

    private HostAndPortAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        return exchange.getHostAndPort();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Host and Port", newValue);
    }

    public String toString() {
        return HOST_AND_PORT;
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Host and Port";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(HostAndPortAttribute.HOST_AND_PORT)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

