/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.attribute;

import libs.io.undertow.attribute.ExchangeAttribute;
import libs.io.undertow.attribute.ExchangeAttributeBuilder;
import libs.io.undertow.attribute.ReadOnlyAttributeException;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.util.QueryParameterUtils;

public class RelativePathAttribute
implements ExchangeAttribute {
    public static final String RELATIVE_PATH_SHORT = "%R";
    public static final String RELATIVE_PATH = "%{RELATIVE_PATH}";
    public static final ExchangeAttribute INSTANCE = new RelativePathAttribute();

    private RelativePathAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        return exchange.getRelativePath();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        int pos = newValue.indexOf(63);
        if (pos == -1) {
            exchange.setRelativePath(newValue);
            String requestURI = exchange.getResolvedPath() + newValue;
            if (requestURI.contains("%")) {
                exchange.setRequestURI(requestURI.replaceAll("%", "%25"));
            } else {
                exchange.setRequestURI(requestURI);
            }
            exchange.setRequestPath(requestURI);
        } else {
            String path = newValue.substring(0, pos);
            exchange.setRelativePath(path);
            String requestURI = exchange.getResolvedPath() + path;
            if (requestURI.contains("%")) {
                exchange.setRequestURI(requestURI.replaceAll("%", "%25"));
            } else {
                exchange.setRequestURI(requestURI);
            }
            exchange.setRequestPath(requestURI);
            String newQueryString = newValue.substring(pos);
            exchange.setQueryString(newQueryString);
            exchange.getQueryParameters().putAll(QueryParameterUtils.parseQueryString(newQueryString.substring(1), QueryParameterUtils.getQueryParamEncoding(exchange)));
        }
    }

    public String toString() {
        return RELATIVE_PATH;
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Relative Path";
        }

        @Override
        public ExchangeAttribute build(String token) {
            return token.equals(RelativePathAttribute.RELATIVE_PATH) || token.equals(RelativePathAttribute.RELATIVE_PATH_SHORT) ? INSTANCE : null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

