/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.predicate;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import libs.io.undertow.attribute.ExchangeAttribute;
import libs.io.undertow.predicate.Predicate;
import libs.io.undertow.predicate.PredicateBuilder;
import libs.io.undertow.server.HttpServerExchange;

public class ExistsPredicate
implements Predicate {
    private final ExchangeAttribute attribute;

    ExistsPredicate(ExchangeAttribute attribute) {
        this.attribute = attribute;
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        String att = this.attribute.readAttribute(value);
        if (att == null) {
            return false;
        }
        return !att.isEmpty();
    }

    public String toString() {
        return "exists( '" + this.attribute.toString() + "' )";
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "exists";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put("value", ExchangeAttribute.class);
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("value");
        }

        @Override
        public String defaultParameter() {
            return "value";
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            ExchangeAttribute value = (ExchangeAttribute)config.get("value");
            return new ExistsPredicate(value);
        }
    }
}

