/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.predicate;

import libs.io.undertow.predicate.Predicate;
import libs.io.undertow.server.HttpServerExchange;

class OrPredicate
implements Predicate {
    private final Predicate[] predicates;

    OrPredicate(Predicate ... predicates) {
        this.predicates = predicates;
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        for (Predicate predicate : this.predicates) {
            if (!predicate.resolve(value)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Predicate predicate : this.predicates) {
            if (result.length() > 0) {
                result.append(" or ");
            }
            result.append(predicate.toString());
        }
        return result.toString();
    }
}

