/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.protocols.http2;

import java.nio.ByteBuffer;
import libs.io.undertow.UndertowMessages;
import libs.io.undertow.protocols.http2.Http2Channel;
import libs.io.undertow.protocols.http2.Http2NoDataStreamSinkChannel;
import libs.io.undertow.protocols.http2.Http2ProtocolUtils;
import libs.io.undertow.server.protocol.framed.SendFrameHeader;
import libs.io.undertow.util.ImmediatePooledByteBuffer;

class Http2PingStreamSinkChannel
extends Http2NoDataStreamSinkChannel {
    public static final int HEADER = 2054;
    private final byte[] data;
    private final boolean ack;

    protected Http2PingStreamSinkChannel(Http2Channel channel, byte[] data, boolean ack) {
        super(channel);
        if (data.length != 8) {
            throw new IllegalArgumentException(UndertowMessages.MESSAGES.httpPingDataMustBeLength8());
        }
        this.data = data;
        this.ack = ack;
    }

    @Override
    protected SendFrameHeader createFrameHeader() {
        ByteBuffer buf = ByteBuffer.allocate(17);
        Http2ProtocolUtils.putInt(buf, 2054);
        buf.put((byte)(this.ack ? 1 : 0));
        Http2ProtocolUtils.putInt(buf, 0);
        for (int i = 0; i < 8; ++i) {
            buf.put(this.data[i]);
        }
        buf.flip();
        return new SendFrameHeader(new ImmediatePooledByteBuffer(buf));
    }
}

