/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.protocols.http2;

import java.nio.ByteBuffer;
import libs.io.undertow.protocols.http2.Http2FrameHeaderParser;
import libs.io.undertow.protocols.http2.Http2ProtocolUtils;
import libs.io.undertow.protocols.http2.Http2PushBackParser;
import libs.org.xnio.Bits;

class Http2PriorityParser
extends Http2PushBackParser {
    private int streamDependency;
    private int weight;
    private boolean exclusive;

    Http2PriorityParser(int frameLength) {
        super(frameLength);
    }

    @Override
    protected void handleData(ByteBuffer resource, Http2FrameHeaderParser frameHeaderParser) {
        if (resource.remaining() < 5) {
            return;
        }
        int read = Http2ProtocolUtils.readInt(resource);
        if (Bits.anyAreSet(read, Integer.MIN_VALUE)) {
            this.exclusive = true;
            this.streamDependency = read & Integer.MAX_VALUE;
        } else {
            this.exclusive = false;
            this.streamDependency = read;
        }
        this.weight = resource.get();
    }

    public int getWeight() {
        return this.weight;
    }

    public int getStreamDependency() {
        return this.streamDependency;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }
}

