/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.protocols.http2;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import libs.io.undertow.protocols.http2.Http2FrameHeaderParser;
import libs.io.undertow.protocols.http2.Http2PushBackParser;
import libs.io.undertow.protocols.http2.Http2Setting;

class Http2SettingsParser
extends Http2PushBackParser {
    private int count = 0;
    private final List<Http2Setting> settings = new ArrayList<Http2Setting>();

    Http2SettingsParser(int frameLength) {
        super(frameLength);
    }

    @Override
    protected void handleData(ByteBuffer resource, Http2FrameHeaderParser parser) {
        while (this.count < parser.length) {
            if (resource.remaining() < 6) {
                return;
            }
            int id = (resource.get() & 0xFF) << 8;
            long value = ((long)resource.get() & 0xFFL) << 24;
            value += ((long)resource.get() & 0xFFL) << 16;
            value += ((long)resource.get() & 0xFFL) << 8;
            this.settings.add(new Http2Setting(id += resource.get() & 0xFF, value += (long)resource.get() & 0xFFL));
            this.count += 6;
        }
    }

    public List<Http2Setting> getSettings() {
        return this.settings;
    }
}

