/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.security.handlers;

import libs.io.undertow.security.api.SecurityContext;
import libs.io.undertow.server.HttpHandler;
import libs.io.undertow.server.HttpServerExchange;

public class AuthenticationCallHandler
implements HttpHandler {
    private final HttpHandler next;

    public AuthenticationCallHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.isInIoThread()) {
            exchange.dispatch(this);
            return;
        }
        SecurityContext context = exchange.getSecurityContext();
        if (context.authenticate()) {
            if (!exchange.isComplete()) {
                this.next.handleRequest(exchange);
            }
        } else {
            exchange.endExchange();
        }
    }
}

