/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.server;

import java.nio.ByteBuffer;
import libs.io.undertow.connector.ByteBufferPool;
import libs.io.undertow.connector.PooledByteBuffer;
import libs.io.undertow.server.DefaultByteBufferPool;
import libs.org.xnio.Pool;
import libs.org.xnio.Pooled;

public class XnioByteBufferPool
implements ByteBufferPool {
    private final Pool<ByteBuffer> pool;
    private final ByteBufferPool arrayBackedPool;
    private final int bufferSize;
    private final boolean direct;

    public XnioByteBufferPool(Pool<ByteBuffer> pool) {
        this.pool = pool;
        Pooled<ByteBuffer> buf = pool.allocate();
        this.bufferSize = buf.getResource().remaining();
        this.direct = !buf.getResource().hasArray();
        buf.free();
        this.arrayBackedPool = this.direct ? new DefaultByteBufferPool(false, this.bufferSize) : this;
    }

    @Override
    public PooledByteBuffer allocate() {
        final Pooled<ByteBuffer> buf = this.pool.allocate();
        return new PooledByteBuffer(){
            private boolean open = true;

            @Override
            public ByteBuffer getBuffer() {
                return (ByteBuffer)buf.getResource();
            }

            @Override
            public void close() {
                this.open = false;
                buf.free();
            }

            @Override
            public boolean isOpen() {
                return this.open;
            }
        };
    }

    @Override
    public ByteBufferPool getArrayBackedPool() {
        return this.arrayBackedPool;
    }

    @Override
    public void close() {
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public boolean isDirect() {
        return this.direct;
    }
}

