/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.server.handlers.encoding;

import java.util.zip.Deflater;
import libs.io.undertow.UndertowLogger;
import libs.io.undertow.conduits.DeflatingStreamSinkConduit;
import libs.io.undertow.server.ConduitWrapper;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.server.handlers.encoding.ContentEncodingProvider;
import libs.io.undertow.util.ConduitFactory;
import libs.io.undertow.util.ObjectPool;
import libs.org.xnio.conduits.StreamSinkConduit;

public class DeflateEncodingProvider
implements ContentEncodingProvider {
    private final ObjectPool<Deflater> deflaterPool;

    public DeflateEncodingProvider() {
        this(8);
    }

    public DeflateEncodingProvider(int deflateLevel) {
        this(DeflatingStreamSinkConduit.newInstanceDeflaterPool(deflateLevel));
    }

    public DeflateEncodingProvider(ObjectPool<Deflater> deflaterPool) {
        this.deflaterPool = deflaterPool;
    }

    @Override
    public ConduitWrapper<StreamSinkConduit> getResponseWrapper() {
        return new ConduitWrapper<StreamSinkConduit>(){

            @Override
            public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
                UndertowLogger.REQUEST_LOGGER.tracef("Created DEFLATE response conduit for %s", (Object)exchange);
                return new DeflatingStreamSinkConduit(factory, exchange, DeflateEncodingProvider.this.deflaterPool);
            }
        };
    }
}

