/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.server.handlers.encoding;

import java.util.zip.Deflater;
import libs.io.undertow.UndertowLogger;
import libs.io.undertow.conduits.DeflatingStreamSinkConduit;
import libs.io.undertow.conduits.GzipStreamSinkConduit;
import libs.io.undertow.server.ConduitWrapper;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.server.handlers.encoding.ContentEncodingProvider;
import libs.io.undertow.util.ConduitFactory;
import libs.io.undertow.util.ObjectPool;
import libs.org.xnio.conduits.StreamSinkConduit;

public class GzipEncodingProvider
implements ContentEncodingProvider {
    private final ObjectPool<Deflater> deflaterPool;

    public GzipEncodingProvider() {
        this(-1);
    }

    public GzipEncodingProvider(int deflateLevel) {
        this(DeflatingStreamSinkConduit.newInstanceDeflaterPool(deflateLevel));
    }

    public GzipEncodingProvider(ObjectPool<Deflater> deflaterPool) {
        this.deflaterPool = deflaterPool;
    }

    @Override
    public ConduitWrapper<StreamSinkConduit> getResponseWrapper() {
        return new ConduitWrapper<StreamSinkConduit>(){

            @Override
            public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
                UndertowLogger.REQUEST_LOGGER.tracef("Created GZIP response conduit for %s", (Object)exchange);
                return new GzipStreamSinkConduit(factory, exchange, (ObjectPool)GzipEncodingProvider.this.deflaterPool);
            }
        };
    }
}

