/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.server.handlers.proxy.mod_cluster;

import java.util.concurrent.TimeUnit;
import libs.io.undertow.server.handlers.proxy.mod_cluster.Balancer;
import libs.io.undertow.server.handlers.proxy.mod_cluster.Context;
import libs.io.undertow.server.handlers.proxy.mod_cluster.Node;

class MCMPInfoUtil {
    private static final String NEWLINE = "\n";

    MCMPInfoUtil() {
    }

    static void printDump(Balancer balancer, StringBuilder builder) {
        builder.append("balancer: [").append(balancer.getId()).append("]").append(" Name: ").append(balancer.getName()).append(" Sticky: ").append(MCMPInfoUtil.toStringOneZero(balancer.isStickySession())).append(" [").append(balancer.getStickySessionCookie()).append("]/[").append(balancer.getStickySessionPath()).append("]").append(" remove: ").append(MCMPInfoUtil.toStringOneZero(balancer.isStickySessionRemove())).append(" force: ").append(MCMPInfoUtil.toStringOneZero(balancer.isStickySessionForce())).append(" Timeout: ").append(balancer.getWaitWorker()).append(" maxAttempts: ").append(balancer.getMaxRetries()).append(NEWLINE);
    }

    static void printInfo(Node.VHostMapping host, StringBuilder builder) {
        for (String alias : host.getAliases()) {
            builder.append("Vhost: [").append(host.getNode().getId()).append(":").append(host.getId()).append(":").append(-1).append("], Alias: ").append(alias).append(NEWLINE);
        }
    }

    static void printDump(Node.VHostMapping host, StringBuilder builder) {
        for (String alias : host.getAliases()) {
            builder.append("host: ").append(host.getId()).append(" [").append(alias).append("]").append(" vhost: ").append(host.getId()).append(" node: ").append(host.getNode().getId()).append(NEWLINE);
        }
    }

    static void printInfo(Context context, StringBuilder builder) {
        builder.append("Context: [").append(context.getNode().getId()).append(":").append(context.getVhost().getId()).append(":").append(context.getId()).append("]").append(", Context: ").append(context.getPath()).append(", Status: ").append((Object)context.getStatus()).append(NEWLINE);
    }

    static void printDump(Context context, StringBuilder builder) {
        builder.append("context: ").append(context.getId()).append(" [").append(context.getPath()).append("]").append(" vhost: ").append(context.getVhost().getId()).append(" node: ").append(context.getNode().getId()).append(" status: ").append(MCMPInfoUtil.formatStatus(context.getStatus())).append(NEWLINE);
    }

    static void printInfo(Node node, StringBuilder builder) {
        builder.append("Node: ").append("[").append(node.getId()).append("]").append(",Name: ").append(node.getJvmRoute()).append(",Balancer: ").append(node.getNodeConfig().getBalancer()).append(",LBGroup: ").append(MCMPInfoUtil.formatString(node.getNodeConfig().getDomain())).append(",Host: ").append(node.getNodeConfig().getConnectionURI().getHost()).append(",Port: ").append(node.getNodeConfig().getConnectionURI().getPort()).append(",Type: ").append(node.getNodeConfig().getConnectionURI().getScheme()).append(",Flushpackets: ").append(MCMPInfoUtil.toStringOnOff(node.getNodeConfig().isFlushPackets())).append(",Flushwait: ").append(node.getNodeConfig().getFlushwait()).append(",Ping: ").append(node.getNodeConfig().getPing()).append(",Smax: ").append(node.getNodeConfig().getSmax()).append(",Ttl: ").append(TimeUnit.MILLISECONDS.toSeconds(node.getNodeConfig().getTtl())).append(",Elected: ").append(node.getElected()).append(",Read: ").append(node.getConnectionPool().getClientStatistics().getRead()).append(",Transfered: ").append(node.getConnectionPool().getClientStatistics().getWritten()).append(",Connected: ").append(node.getConnectionPool().getOpenConnections()).append(",Load: ").append(node.getLoad()).append(NEWLINE);
    }

    static void printDump(Node node, StringBuilder builder) {
        builder.append("node: [").append(node.getBalancer().getId()).append(":").append(node.getId()).append("]").append(",Balancer: ").append(node.getNodeConfig().getBalancer()).append(",JVMRoute: ").append(node.getJvmRoute()).append(",LBGroup: [").append(MCMPInfoUtil.formatString(node.getNodeConfig().getDomain())).append("]").append(",Host: ").append(node.getNodeConfig().getConnectionURI().getHost()).append(",Port: ").append(node.getNodeConfig().getConnectionURI().getPort()).append(",Type: ").append(node.getNodeConfig().getConnectionURI().getScheme()).append(",flushpackets: ").append(MCMPInfoUtil.toStringOneZero(node.getNodeConfig().isFlushPackets())).append(",flushwait: ").append(node.getNodeConfig().getFlushwait()).append(",ping: ").append(node.getNodeConfig().getPing()).append(",smax: ").append(node.getNodeConfig().getSmax()).append(",ttl: ").append(TimeUnit.MILLISECONDS.toSeconds(node.getNodeConfig().getTtl())).append(",timeout: ").append(node.getNodeConfig().getTimeout()).append(NEWLINE);
    }

    static String toStringOneZero(boolean bool) {
        return bool ? "1" : "0";
    }

    static String toStringOnOff(boolean bool) {
        return bool ? "On" : "Off";
    }

    static String formatString(String str) {
        return str == null ? "" : str;
    }

    static int formatStatus(Context.Status status) {
        return status == Context.Status.ENABLED ? 1 : (status == Context.Status.DISABLED ? 2 : (status == Context.Status.STOPPED ? 3 : -1));
    }
}

