/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.server.handlers.sse;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import libs.io.undertow.UndertowLogger;
import libs.io.undertow.server.HttpHandler;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.server.handlers.sse.ServerSentEventConnection;
import libs.io.undertow.server.handlers.sse.ServerSentEventConnectionCallback;
import libs.io.undertow.util.Headers;
import libs.io.undertow.util.HttpString;
import libs.io.undertow.util.PathTemplateMatch;
import libs.org.xnio.ChannelExceptionHandler;
import libs.org.xnio.ChannelListener;
import libs.org.xnio.ChannelListeners;
import libs.org.xnio.IoUtils;
import libs.org.xnio.channels.StreamSinkChannel;

public class ServerSentEventHandler
implements HttpHandler {
    private static final HttpString LAST_EVENT_ID = new HttpString("Last-Event-ID");
    private final ServerSentEventConnectionCallback callback;
    private final Set<ServerSentEventConnection> connections = Collections.newSetFromMap(new ConcurrentHashMap());

    public ServerSentEventHandler(ServerSentEventConnectionCallback callback) {
        this.callback = callback;
    }

    public ServerSentEventHandler() {
        this.callback = null;
    }

    @Override
    public void handleRequest(final HttpServerExchange exchange) throws Exception {
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/event-stream; charset=UTF-8");
        exchange.setPersistent(false);
        final StreamSinkChannel sink = exchange.getResponseChannel();
        if (!sink.flush()) {
            sink.getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<StreamSinkChannel>(){

                @Override
                public void handleEvent(StreamSinkChannel channel) {
                    ServerSentEventHandler.this.handleConnect(channel, exchange);
                }
            }, new ChannelExceptionHandler<StreamSinkChannel>(){

                @Override
                public void handleException(StreamSinkChannel channel, IOException exception) {
                    IoUtils.safeClose((Closeable)exchange.getConnection());
                }
            }));
            sink.resumeWrites();
        } else {
            exchange.dispatch((Executor)exchange.getIoThread(), new Runnable(){

                @Override
                public void run() {
                    ServerSentEventHandler.this.handleConnect(sink, exchange);
                }
            });
        }
    }

    private void handleConnect(StreamSinkChannel channel, HttpServerExchange exchange) {
        UndertowLogger.REQUEST_LOGGER.debugf("Opened SSE connection to %s", (Object)exchange);
        final ServerSentEventConnection connection = new ServerSentEventConnection(exchange, channel);
        PathTemplateMatch pt = exchange.getAttachment(PathTemplateMatch.ATTACHMENT_KEY);
        if (pt != null) {
            for (Map.Entry<String, String> p : pt.getParameters().entrySet()) {
                connection.setParameter(p.getKey(), p.getValue());
            }
        }
        this.connections.add(connection);
        connection.addCloseTask(new ChannelListener<ServerSentEventConnection>(){

            @Override
            public void handleEvent(ServerSentEventConnection channel) {
                ServerSentEventHandler.this.connections.remove(connection);
            }
        });
        if (this.callback != null) {
            this.callback.connected(connection, exchange.getRequestHeaders().getLast(LAST_EVENT_ID));
        }
    }

    public Set<ServerSentEventConnection> getConnections() {
        return Collections.unmodifiableSet(this.connections);
    }
}

