/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.server.protocol.framed;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import libs.io.undertow.UndertowLogger;
import libs.io.undertow.UndertowMessages;
import libs.io.undertow.connector.PooledByteBuffer;
import libs.io.undertow.server.protocol.framed.AbstractFramedChannel;
import libs.io.undertow.server.protocol.framed.AbstractFramedStreamSourceChannel;
import libs.io.undertow.server.protocol.framed.SendFrameHeader;
import libs.io.undertow.util.ImmediatePooledByteBuffer;
import libs.org.xnio.Bits;
import libs.org.xnio.Buffers;
import libs.org.xnio.ChannelListener;
import libs.org.xnio.ChannelListeners;
import libs.org.xnio.IoUtils;
import libs.org.xnio.Option;
import libs.org.xnio.Options;
import libs.org.xnio.XnioExecutor;
import libs.org.xnio.XnioIoThread;
import libs.org.xnio.XnioWorker;
import libs.org.xnio.channels.Channels;
import libs.org.xnio.channels.StreamSinkChannel;
import libs.org.xnio.channels.StreamSourceChannel;

public abstract class AbstractFramedStreamSinkChannel<C extends AbstractFramedChannel<C, R, S>, R extends AbstractFramedStreamSourceChannel<C, R, S>, S extends AbstractFramedStreamSinkChannel<C, R, S>>
implements StreamSinkChannel {
    private static final int AWAIT_WRITABLE_TIMEOUT;
    private static final int FUZZ_FACTOR = 50;
    private static final PooledByteBuffer EMPTY_BYTE_BUFFER;
    private final C channel;
    private final ChannelListener.SimpleSetter<S> writeSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<S> closeSetter = new ChannelListener.SimpleSetter();
    private final Object lock = new Object();
    private volatile XnioExecutor.Key handle = null;
    private volatile long flushExpirationTime = -1L;
    private final TimeoutRunnable timeoutRunnable;
    private volatile int state = 0;
    private volatile boolean readyForFlush;
    private volatile boolean fullyFlushed;
    private volatile boolean finalFrameQueued;
    private volatile boolean broken;
    private volatile int waiterCount = 0;
    private volatile SendFrameHeader header;
    private volatile PooledByteBuffer writeBuffer;
    private volatile PooledByteBuffer body;
    private static final int STATE_CLOSED = 1;
    private static final int STATE_WRITES_SHUTDOWN = 2;
    private static final int STATE_FIRST_DATA_WRITTEN = 4;
    private static final int STATE_PRE_WRITE_CALLED = 8;
    private volatile boolean bufferFull;
    private volatile boolean writesResumed;
    private volatile int inListenerLoop;
    private volatile boolean writeSucceeded;
    private static final AtomicIntegerFieldUpdater<AbstractFramedStreamSinkChannel> inListenerLoopUpdater;

    protected AbstractFramedStreamSinkChannel(C channel) {
        this.channel = channel;
        this.timeoutRunnable = new TimeoutRunnable(this);
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, this);
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer(source, count, throughBuffer, this);
    }

    @Override
    public void suspendWrites() {
        this.writesResumed = false;
    }

    final SendFrameHeader getFrameHeader() throws IOException {
        if (this.header == null) {
            this.header = this.createFrameHeader();
            if (this.header == null) {
                this.header = new SendFrameHeader(0, null);
            }
        }
        return this.header;
    }

    protected SendFrameHeader createFrameHeader() throws IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void preWrite() {
        Object object = this.lock;
        synchronized (object) {
            if (Bits.allAreClear(this.state, 8)) {
                this.state |= 8;
                this.body = this.preWriteTransform(this.body);
            }
        }
    }

    protected PooledByteBuffer preWriteTransform(PooledByteBuffer body) {
        return body;
    }

    @Override
    public boolean isWriteResumed() {
        return this.writesResumed;
    }

    @Override
    public void wakeupWrites() {
        this.resumeWritesInternal(true);
    }

    @Override
    public void resumeWrites() {
        this.resumeWritesInternal(false);
    }

    protected void resumeWritesInternal(boolean wakeup) {
        boolean alreadyResumed = this.writesResumed;
        if (!wakeup && alreadyResumed) {
            return;
        }
        this.writesResumed = true;
        if (this.readyForFlush && !wakeup) {
            return;
        }
        if (inListenerLoopUpdater.compareAndSet(this, 0, 1)) {
            ((AbstractFramedChannel)this.getChannel()).runInIoThread(new Runnable(){
                int loopCount = 0;

                @Override
                public void run() {
                    try {
                        ChannelListener listener = AbstractFramedStreamSinkChannel.this.getWriteListener();
                        if (listener == null || !AbstractFramedStreamSinkChannel.this.isWriteResumed()) {
                            return;
                        }
                        if (AbstractFramedStreamSinkChannel.this.writeSucceeded) {
                            AbstractFramedStreamSinkChannel.this.writeSucceeded = false;
                            this.loopCount = 0;
                        } else if (this.loopCount++ == 100) {
                            UndertowLogger.ROOT_LOGGER.listenerNotProgressing();
                            IoUtils.safeClose((Closeable)AbstractFramedStreamSinkChannel.this);
                            return;
                        }
                        ChannelListeners.invokeChannelListener(AbstractFramedStreamSinkChannel.this, listener);
                    }
                    finally {
                        inListenerLoopUpdater.set(AbstractFramedStreamSinkChannel.this, 0);
                    }
                    if (AbstractFramedStreamSinkChannel.this.writesResumed && Bits.allAreClear(AbstractFramedStreamSinkChannel.this.state, 1) && !AbstractFramedStreamSinkChannel.this.broken && !AbstractFramedStreamSinkChannel.this.readyForFlush && !AbstractFramedStreamSinkChannel.this.fullyFlushed && inListenerLoopUpdater.compareAndSet(AbstractFramedStreamSinkChannel.this, 0, 1)) {
                        AbstractFramedStreamSinkChannel.this.getIoThread().execute(this);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownWrites() throws IOException {
        this.queueFinalFrame();
        Object object = this.lock;
        synchronized (object) {
            if (Bits.anyAreSet(this.state, 2) || this.broken) {
                return;
            }
            this.state |= 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueFinalFrame() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!(this.readyForFlush || this.fullyFlushed || !Bits.allAreClear(this.state, 1) || this.broken || this.finalFrameQueued)) {
                if (null == this.body && null != this.writeBuffer) {
                    this.sendWriteBuffer();
                } else if (null == this.body) {
                    this.body = EMPTY_BYTE_BUFFER;
                }
                this.readyForFlush = true;
                this.state |= 4;
                this.state |= 2;
            } else {
                return;
            }
            this.finalFrameQueued = true;
        }
        ((AbstractFramedChannel)this.channel).queueFrame((AbstractFramedStreamSinkChannel)this);
    }

    protected boolean isFinalFrameQueued() {
        return this.finalFrameQueued;
    }

    @Override
    public void awaitWritable() throws IOException {
        this.awaitWritable(this.getAwaitWritableTimeout(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitWritable(long l, TimeUnit timeUnit) throws IOException {
        if (Thread.currentThread() == this.getIoThread()) {
            throw UndertowMessages.MESSAGES.awaitCalledFromIoThread();
        }
        Object object = this.lock;
        synchronized (object) {
            if (Bits.anyAreSet(this.state, 1) || this.broken) {
                return;
            }
            if (this.readyForFlush) {
                try {
                    ++this.waiterCount;
                    if (this.readyForFlush && !Bits.anyAreSet(this.state, 1) && !this.broken) {
                        this.lock.wait(timeUnit.toMillis(l));
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
                finally {
                    --this.waiterCount;
                }
            }
        }
    }

    @Override
    public XnioExecutor getWriteThread() {
        return ((AbstractFramedChannel)this.channel).getIoThread();
    }

    public ChannelListener.Setter<? extends S> getWriteSetter() {
        return this.writeSetter;
    }

    public ChannelListener.Setter<? extends S> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public XnioWorker getWorker() {
        return ((AbstractFramedChannel)this.channel).getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return ((AbstractFramedChannel)this.channel).getIoThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flush() throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            return true;
        }
        if (this.broken) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        if (this.readyForFlush) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.fullyFlushed) {
                this.state |= 1;
                return true;
            }
        }
        if (Bits.anyAreSet(this.state, 2) && !this.finalFrameQueued) {
            this.queueFinalFrame();
            return false;
        }
        if (Bits.anyAreSet(this.state, 2)) {
            return false;
        }
        if (this.isFlushRequiredOnEmptyBuffer() || this.writeBuffer != null && this.writeBuffer.getBuffer().position() > 0) {
            this.handleBufferFull();
            return !this.readyForFlush;
        }
        return true;
    }

    protected boolean isFlushRequiredOnEmptyBuffer() {
        return false;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        PooledByteBuffer localWriteBuffer = this.getWriteBuffer();
        if (localWriteBuffer == null) {
            return 0L;
        }
        ByteBuffer buffer = localWriteBuffer.getBuffer();
        int copied = Buffers.copy(buffer, srcs, offset, length);
        if (!buffer.hasRemaining()) {
            this.handleBufferFull();
        }
        this.writeSucceeded = this.writeSucceeded || copied > 0;
        return copied;
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        ByteBuffer buffer;
        PooledByteBuffer localWriteBuffer = this.getWriteBuffer();
        if (localWriteBuffer == null) {
            return 0;
        }
        try {
            buffer = localWriteBuffer.getBuffer();
        }
        catch (IllegalStateException e) {
            if (!this.safeToSend()) {
                return 0;
            }
            throw e;
        }
        int copied = Buffers.copy(buffer, src);
        if (!buffer.hasRemaining()) {
            this.handleBufferFull();
        }
        this.writeSucceeded = this.writeSucceeded || copied > 0;
        return copied;
    }

    private PooledByteBuffer getWriteBuffer() throws IOException {
        PooledByteBuffer localWriteBuffer;
        if (!this.safeToSend()) {
            return null;
        }
        if (this.writeBuffer == null) {
            this.writeBuffer = ((AbstractFramedChannel)this.getChannel()).getBufferPool().allocate();
        }
        if ((localWriteBuffer = this.writeBuffer) == null) {
            this.safeToSend();
        }
        return localWriteBuffer;
    }

    public boolean send(PooledByteBuffer pooled) throws IOException {
        if (this.isWritesShutdown()) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        boolean result = this.sendInternal(pooled);
        if (result) {
            this.flush();
        }
        return result;
    }

    protected boolean sendInternal(PooledByteBuffer pooled) throws IOException {
        if (this.safeToSend()) {
            this.body = pooled;
            this.writeSucceeded = true;
            return true;
        }
        return false;
    }

    protected boolean safeToSend() throws IOException {
        int state = this.state;
        if (Bits.anyAreSet(state, 1) || this.broken) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        if (this.readyForFlush) {
            return false;
        }
        if (null != this.body) {
            throw UndertowMessages.MESSAGES.bodyIsSetAndNotReadyForFlush();
        }
        return true;
    }

    protected long getAwaitWritableTimeout() {
        Integer timeout = null;
        try {
            timeout = ((AbstractFramedChannel)this.getChannel()).getOption(Options.WRITE_TIMEOUT);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (timeout != null && timeout > 0) {
            return timeout.intValue();
        }
        return AWAIT_WRITABLE_TIMEOUT;
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Channels.writeFinalBasic(this, srcs, offset, length);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs) throws IOException {
        return this.writeFinal(srcs, 0, srcs.length);
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return Channels.writeFinalBasic(this, src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBufferFull() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.bufferFull = true;
            if (this.readyForFlush) {
                return;
            }
            this.sendWriteBuffer();
            this.readyForFlush = true;
            this.state |= 4;
        }
        ((AbstractFramedChannel)this.channel).queueFrame((AbstractFramedStreamSinkChannel)this);
    }

    private void sendWriteBuffer() throws IOException {
        PooledByteBuffer localWriteBuffer = this.getWriteBuffer();
        if (localWriteBuffer == null) {
            localWriteBuffer = EMPTY_BYTE_BUFFER;
        }
        localWriteBuffer.getBuffer().flip();
        if (!this.sendInternal(localWriteBuffer)) {
            throw UndertowMessages.MESSAGES.failedToSendAfterBeingSafe();
        }
        this.writeBuffer = null;
    }

    protected abstract boolean isLastFrame();

    public boolean isReadyForFlush() {
        return this.readyForFlush;
    }

    public boolean isWritesShutdown() {
        return Bits.anyAreSet(this.state, 2);
    }

    @Override
    public boolean isOpen() {
        return Bits.allAreClear(this.state, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.fullyFlushed || Bits.anyAreSet(this.state, 1)) {
            return;
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                block13: {
                    if (!this.fullyFlushed && !Bits.anyAreSet(this.state, 1)) break block13;
                    return;
                }
                this.state |= 1;
                if (this.writeBuffer != null) {
                    this.writeBuffer.close();
                    this.writeBuffer = null;
                }
                if (this.body != null) {
                    this.body.close();
                    this.body = null;
                }
                if (this.header != null && this.header.getByteBuffer() != null) {
                    this.header.getByteBuffer().close();
                    this.header = null;
                }
                this.removeHandle();
            }
            this.channelForciblyClosed();
            if (this.isWriteResumed()) {
                ChannelListeners.invokeChannelListener(this.getIoThread(), this, this.getWriteListener());
            }
            this.wakeupWrites();
        }
        finally {
            this.wakeupWaiters();
        }
    }

    protected void channelForciblyClosed() throws IOException {
        if (this.isFirstDataWritten()) {
            ((AbstractFramedChannel)this.getChannel()).markWritesBroken(null);
        }
        this.removeHandle();
        this.wakeupWaiters();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return false;
    }

    @Override
    public <T> T getOption(Option<T> tOption) throws IOException {
        return null;
    }

    @Override
    public <T> T setOption(Option<T> tOption, T t) throws IllegalArgumentException, IOException {
        return null;
    }

    public ByteBuffer getBuffer() {
        if (Bits.anyAreSet(this.state, 1)) {
            throw new IllegalStateException();
        }
        if (this.body == null) {
            this.body = EMPTY_BYTE_BUFFER;
        }
        return this.body.getBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void flushComplete() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                boolean channelClosed;
                boolean resetReadyForFlush = true;
                this.bufferFull = false;
                int remaining = this.header.getRemainingInBuffer();
                boolean finalFrame = this.finalFrameQueued;
                boolean bl = channelClosed = finalFrame && remaining == 0 && !this.header.isAnotherFrameRequired();
                if (remaining > 0) {
                    this.body.getBuffer().limit(this.body.getBuffer().limit() + remaining);
                    this.body.getBuffer().compact();
                    this.writeBuffer = this.body;
                    this.body = null;
                    this.state &= 0xFFFFFFF7;
                    if (finalFrame) {
                        this.finalFrameQueued = false;
                        this.readyForFlush = false;
                        resetReadyForFlush = false;
                        this.flushExpirationTime = -1L;
                        this.queueFinalFrame();
                    }
                } else if (this.header.isAnotherFrameRequired()) {
                    this.finalFrameQueued = false;
                    if (this.body != null) {
                        this.body.close();
                        this.body = null;
                        this.state &= 0xFFFFFFF7;
                    }
                } else if (this.body != null) {
                    this.body.close();
                    this.body = null;
                    this.state &= 0xFFFFFFF7;
                }
                if (channelClosed) {
                    this.fullyFlushed = true;
                    this.removeHandle();
                    if (this.body != null) {
                        this.body.close();
                        this.body = null;
                        this.state &= 0xFFFFFFF7;
                    }
                }
                if (this.header.getByteBuffer() != null) {
                    this.header.getByteBuffer().close();
                }
                this.header = null;
                if (resetReadyForFlush) {
                    this.readyForFlush = false;
                    this.flushExpirationTime = -1L;
                }
                if (this.isWriteResumed() && !channelClosed) {
                    this.wakeupWrites();
                } else if (this.isWriteResumed()) {
                    ChannelListeners.invokeChannelListener(this.getIoThread(), this, this.getWriteListener());
                }
                ChannelListener<S> closeListener = this.closeSetter.get();
                if (channelClosed && closeListener != null) {
                    ChannelListeners.invokeChannelListener(this.getIoThread(), this, closeListener);
                }
                this.handleFlushComplete(channelClosed);
            }
            finally {
                this.wakeupWaiters();
            }
        }
    }

    protected void handleFlushComplete(boolean finalFrame) {
    }

    protected boolean isFirstDataWritten() {
        return Bits.anyAreSet(this.state, 4);
    }

    public void markBroken() {
        this.broken = true;
        try {
            ChannelListener<S> closeListener;
            ChannelListener<S> writeListener;
            this.wakeupWrites();
            this.wakeupWaiters();
            if (this.isWriteResumed() && (writeListener = this.writeSetter.get()) != null) {
                ChannelListeners.invokeChannelListener(this.getIoThread(), this, writeListener);
            }
            if ((closeListener = this.closeSetter.get()) != null) {
                ChannelListeners.invokeChannelListener(this.getIoThread(), this, closeListener);
            }
        }
        finally {
            this.removeHandle();
            if (this.header != null && this.header.getByteBuffer() != null) {
                this.header.getByteBuffer().close();
                this.header = null;
            }
            if (this.body != null) {
                this.body.close();
                this.body = null;
            }
            if (this.writeBuffer != null) {
                this.writeBuffer.close();
                this.writeBuffer = null;
            }
        }
    }

    ChannelListener<? super S> getWriteListener() {
        return this.writeSetter.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeupWaiters() {
        if (this.waiterCount > 0) {
            Object object = this.lock;
            synchronized (object) {
                if (this.waiterCount > 0) {
                    this.lock.notifyAll();
                }
            }
        }
    }

    public C getChannel() {
        return this.channel;
    }

    public boolean isBroken() {
        return this.broken;
    }

    public boolean isBufferFull() {
        return this.bufferFull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHandle() {
        if (this.handle != null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.handle != null) {
                    this.handle.remove();
                    this.handle = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHandle(long timeout) {
        Object object = this.lock;
        synchronized (object) {
            if (this.handle == null) {
                this.handle = ((AbstractFramedChannel)this.getChannel()).getIoThread().executeAfter(this.timeoutRunnable, timeout + 50L, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addReadyForFlushTask() {
        Object object = this.lock;
        synchronized (object) {
            long timeout = this.getAwaitWritableTimeout();
            this.flushExpirationTime = System.currentTimeMillis() + timeout;
            this.addHandle(timeout);
        }
    }

    static {
        int defaultAwaitWritableTimeout = 600000;
        int await_writable_timeout = AccessController.doPrivileged(() -> Integer.getInteger("libs.io.undertow.await_writable_timeout", 600000));
        AWAIT_WRITABLE_TIMEOUT = await_writable_timeout > 0 ? await_writable_timeout : 600000;
        EMPTY_BYTE_BUFFER = new ImmediatePooledByteBuffer(ByteBuffer.allocateDirect(0));
        inListenerLoopUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractFramedStreamSinkChannel.class, "inListenerLoop");
    }

    private static class TimeoutRunnable
    implements Runnable {
        private final AbstractFramedStreamSinkChannel channel;

        TimeoutRunnable(AbstractFramedStreamSinkChannel channel) {
            this.channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long currentTime = System.currentTimeMillis();
            Object object = this.channel.lock;
            synchronized (object) {
                this.channel.handle = null;
                long flushExpirationTime = this.channel.flushExpirationTime;
                if (flushExpirationTime < 0L || !this.channel.isReadyForFlush() || !this.channel.isOpen() || this.channel.isBroken()) {
                    return;
                }
                if (currentTime < flushExpirationTime) {
                    this.channel.addHandle(flushExpirationTime - currentTime);
                    return;
                }
            }
            UndertowLogger.REQUEST_IO_LOGGER.noFrameflushInTimeout(this.channel.getAwaitWritableTimeout());
            try {
                this.channel.channelForciblyClosed();
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.debugf((Throwable)e, "Exception closing the framed sink channel because of timeout", new Object[0]);
                this.channel.markBroken();
            }
        }
    }
}

