/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.util;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.Channel;
import libs.io.undertow.UndertowLogger;
import libs.org.xnio.ChannelExceptionHandler;
import libs.org.xnio.IoUtils;

public class ClosingChannelExceptionHandler<T extends Channel>
implements ChannelExceptionHandler<T> {
    private final Closeable[] closable;

    public ClosingChannelExceptionHandler(Closeable ... closable) {
        this.closable = closable;
    }

    @Override
    public void handleException(T t, IOException e) {
        UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
        IoUtils.safeClose(t);
        IoUtils.safeClose(this.closable);
    }
}

