/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.util;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import libs.io.undertow.UndertowLogger;
import libs.io.undertow.util.WorkerUtils;
import libs.org.xnio.ChannelExceptionHandler;
import libs.org.xnio.ChannelListener;
import libs.org.xnio.ChannelListeners;
import libs.org.xnio.IoUtils;
import libs.org.xnio.StreamConnection;
import libs.org.xnio.XnioExecutor;
import libs.org.xnio.conduits.ConduitStreamSinkChannel;
import libs.org.xnio.conduits.ConduitStreamSourceChannel;

public class ConnectionUtils {
    private static final long MAX_DRAIN_TIME = Long.getLong("libs.io.undertow.max-drain-time", 10000L);

    private ConnectionUtils() {
    }

    public static void cleanClose(final StreamConnection connection, final Closeable ... additional) {
        try {
            connection.getSinkChannel().shutdownWrites();
            if (!connection.getSinkChannel().flush()) {
                connection.getSinkChannel().setWriteListener((ChannelListener<? super ConduitStreamSinkChannel>)ChannelListeners.flushingChannelListener(new ChannelListener<ConduitStreamSinkChannel>(){

                    @Override
                    public void handleEvent(ConduitStreamSinkChannel channel) {
                        ConnectionUtils.doDrain(connection, additional);
                    }
                }, new ChannelExceptionHandler<ConduitStreamSinkChannel>(){

                    @Override
                    public void handleException(ConduitStreamSinkChannel channel, IOException exception) {
                        UndertowLogger.REQUEST_IO_LOGGER.ioException(exception);
                        IoUtils.safeClose((Closeable)connection);
                        IoUtils.safeClose(additional);
                    }
                }));
                connection.getSinkChannel().resumeWrites();
            } else {
                ConnectionUtils.doDrain(connection, additional);
            }
        }
        catch (Throwable e) {
            if (e instanceof IOException) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException((IOException)e);
            } else {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(new IOException(e));
            }
            IoUtils.safeClose((Closeable)connection);
            IoUtils.safeClose(additional);
        }
    }

    private static void doDrain(final StreamConnection connection, final Closeable ... additional) {
        if (!connection.getSourceChannel().isOpen()) {
            IoUtils.safeClose((Closeable)connection);
            IoUtils.safeClose(additional);
            return;
        }
        final ByteBuffer b = ByteBuffer.allocate(1);
        try {
            int res = connection.getSourceChannel().read(b);
            b.clear();
            if (res == 0) {
                final XnioExecutor.Key key = WorkerUtils.executeAfter(connection.getIoThread(), new Runnable(){

                    @Override
                    public void run() {
                        IoUtils.safeClose((Closeable)connection);
                        IoUtils.safeClose(additional);
                    }
                }, MAX_DRAIN_TIME, TimeUnit.MILLISECONDS);
                connection.getSourceChannel().setReadListener((ChannelListener<? super ConduitStreamSourceChannel>)new ChannelListener<ConduitStreamSourceChannel>(){

                    @Override
                    public void handleEvent(ConduitStreamSourceChannel channel) {
                        try {
                            int res = channel.read(b);
                            if (res != 0) {
                                IoUtils.safeClose((Closeable)connection);
                                IoUtils.safeClose(additional);
                                key.remove();
                            }
                        }
                        catch (Exception e) {
                            if (e instanceof IOException) {
                                UndertowLogger.REQUEST_IO_LOGGER.ioException((IOException)e);
                            } else {
                                UndertowLogger.REQUEST_IO_LOGGER.ioException(new IOException(e));
                            }
                            IoUtils.safeClose((Closeable)connection);
                            IoUtils.safeClose(additional);
                            key.remove();
                        }
                    }
                });
                connection.getSourceChannel().resumeReads();
            } else {
                IoUtils.safeClose((Closeable)connection);
                IoUtils.safeClose(additional);
            }
        }
        catch (Throwable e) {
            if (e instanceof IOException) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException((IOException)e);
            } else {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(new IOException(e));
            }
            IoUtils.safeClose((Closeable)connection);
            IoUtils.safeClose(additional);
        }
    }
}

