/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import libs.io.undertow.UndertowLogger;
import libs.io.undertow.UndertowMessages;
import libs.io.undertow.server.handlers.Cookie;
import libs.io.undertow.server.handlers.CookieImpl;
import libs.io.undertow.util.DateUtils;
import libs.io.undertow.util.HeaderMap;
import libs.io.undertow.util.HeaderValues;
import libs.io.undertow.util.Headers;
import libs.io.undertow.util.LegacyCookieSupport;
import libs.io.undertow.util.SecurityActions;

public class Cookies {
    public static final String DOMAIN = "$Domain";
    public static final String VERSION = "$Version";
    public static final String PATH = "$Path";
    private static final String CRUMB_SEPARATOR = "; ";
    private static final String CRUMBS_ASSEMBLY_DISABLE = "libs.io.undertow.server.protocol.http.DisableCookieCrumbsAssembly";
    private static final Boolean CRUMBS_ASSEMBLY_DISABLED = Boolean.valueOf(SecurityActions.getSystemProperty("libs.io.undertow.server.protocol.http.DisableCookieCrumbsAssembly", "false"));

    public static Cookie parseSetCookieHeader(String headerValue) {
        String key = null;
        CookieImpl cookie = null;
        int state = 0;
        int current = 0;
        block5: for (int i = 0; i < headerValue.length(); ++i) {
            char c = headerValue.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '=') {
                        key = headerValue.substring(current, i);
                        current = i + 1;
                        state = 1;
                        continue block5;
                    }
                    if ((c == ';' || c == ' ') && current == i) {
                        ++current;
                        continue block5;
                    }
                    if (c != ';') continue block5;
                    if (cookie == null) {
                        throw UndertowMessages.MESSAGES.couldNotParseCookie(headerValue);
                    }
                    Cookies.handleValue(cookie, headerValue.substring(current, i), null);
                    current = i + 1;
                    continue block5;
                }
                case 1: {
                    if (c == ';') {
                        if (cookie == null) {
                            cookie = new CookieImpl(key, headerValue.substring(current, i));
                        } else {
                            Cookies.handleValue(cookie, key, headerValue.substring(current, i));
                        }
                        state = 0;
                        current = i + 1;
                        key = null;
                        continue block5;
                    }
                    if (c != '\"' || current != i) continue block5;
                    ++current;
                    state = 2;
                    continue block5;
                }
                case 2: {
                    if (c != '\"') continue block5;
                    if (cookie == null) {
                        cookie = new CookieImpl(key, headerValue.substring(current, i));
                    } else {
                        Cookies.handleValue(cookie, key, headerValue.substring(current, i));
                    }
                    state = 0;
                    current = i + 1;
                    key = null;
                }
            }
        }
        if (key == null) {
            if (current != headerValue.length()) {
                Cookies.handleValue(cookie, headerValue.substring(current, headerValue.length()), null);
            }
        } else if (current != headerValue.length()) {
            if (cookie == null) {
                cookie = new CookieImpl(key, headerValue.substring(current, headerValue.length()));
            } else {
                Cookies.handleValue(cookie, key, headerValue.substring(current, headerValue.length()));
            }
        } else {
            Cookies.handleValue(cookie, key, null);
        }
        return cookie;
    }

    private static void handleValue(CookieImpl cookie, String key, String value) {
        if (key == null) {
            return;
        }
        if (key.equalsIgnoreCase("path")) {
            cookie.setPath(value);
        } else if (key.equalsIgnoreCase("domain")) {
            cookie.setDomain(value);
        } else if (key.equalsIgnoreCase("max-age")) {
            cookie.setMaxAge(Integer.parseInt(value));
        } else if (key.equalsIgnoreCase("expires")) {
            cookie.setExpires(DateUtils.parseDate(value));
        } else if (key.equalsIgnoreCase("discard")) {
            cookie.setDiscard(true);
        } else if (key.equalsIgnoreCase("secure")) {
            cookie.setSecure(true);
        } else if (key.equalsIgnoreCase("httpOnly")) {
            cookie.setHttpOnly(true);
        } else if (key.equalsIgnoreCase("version")) {
            cookie.setVersion(Integer.parseInt(value));
        } else if (key.equalsIgnoreCase("comment")) {
            cookie.setComment(value);
        } else if (key.equalsIgnoreCase("samesite")) {
            cookie.setSameSite(true);
            cookie.setSameSiteMode(value);
        }
    }

    @Deprecated(since="2.2.0", forRemoval=true)
    public static Map<String, Cookie> parseRequestCookies(int maxCookies, boolean allowEqualInValue, List<String> cookies) {
        return Cookies.parseRequestCookies(maxCookies, allowEqualInValue, cookies, LegacyCookieSupport.COMMA_IS_SEPARATOR);
    }

    public static void parseRequestCookies(int maxCookies, boolean allowEqualInValue, List<String> cookies, Set<Cookie> parsedCookies) {
        Cookies.parseRequestCookies(maxCookies, allowEqualInValue, cookies, parsedCookies, LegacyCookieSupport.COMMA_IS_SEPARATOR);
    }

    @Deprecated
    static Map<String, Cookie> parseRequestCookies(int maxCookies, boolean allowEqualInValue, List<String> cookies, boolean commaIsSeperator) {
        return Cookies.parseRequestCookies(maxCookies, allowEqualInValue, cookies, commaIsSeperator, LegacyCookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0);
    }

    static void parseRequestCookies(int maxCookies, boolean allowEqualInValue, List<String> cookies, Set<Cookie> parsedCookies, boolean commaIsSeperator) {
        Cookies.parseRequestCookies(maxCookies, allowEqualInValue, cookies, parsedCookies, commaIsSeperator, LegacyCookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0);
    }

    static Map<String, Cookie> parseRequestCookies(int maxCookies, boolean allowEqualInValue, List<String> cookies, boolean commaIsSeperator, boolean allowHttpSepartorsV0) {
        if (cookies == null) {
            return new TreeMap<String, Cookie>();
        }
        HashSet<Cookie> parsedCookies = new HashSet<Cookie>();
        for (String cookie : cookies) {
            Cookies.parseCookie(cookie, parsedCookies, maxCookies, allowEqualInValue, commaIsSeperator, allowHttpSepartorsV0);
        }
        TreeMap<String, Cookie> retVal = new TreeMap<String, Cookie>();
        for (Cookie cookie : parsedCookies) {
            retVal.put(cookie.getName(), cookie);
        }
        return retVal;
    }

    static void parseRequestCookies(int maxCookies, boolean allowEqualInValue, List<String> cookies, Set<Cookie> parsedCookies, boolean commaIsSeperator, boolean allowHttpSepartorsV0) {
        if (cookies != null) {
            for (String cookie : cookies) {
                Cookies.parseCookie(cookie, parsedCookies, maxCookies, allowEqualInValue, commaIsSeperator, allowHttpSepartorsV0);
            }
        }
    }

    private static void parseCookie(String cookie, Set<Cookie> parsedCookies, int maxCookies, boolean allowEqualInValue, boolean commaIsSeperator, boolean allowHttpSepartorsV0) {
        CookieImpl c;
        int state = 0;
        String name = null;
        int start = 0;
        boolean containsEscapedQuotes = false;
        int cookieCount = parsedCookies.size();
        HashMap<String, String> cookies = new HashMap<String, String>();
        HashMap<String, String> additional = new HashMap<String, String>();
        block7: for (int i = 0; i < cookie.length(); ++i) {
            char c2 = cookie.charAt(i);
            switch (state) {
                case 0: {
                    if (c2 == ' ' || c2 == '\t' || c2 == ';') {
                        start = i + 1;
                        continue block7;
                    }
                    state = 1;
                }
                case 1: {
                    if (c2 == '=') {
                        name = cookie.substring(start, i);
                        start = i + 1;
                        state = 2;
                        continue block7;
                    }
                    if (c2 != ';' && (!commaIsSeperator || c2 != ',')) continue block7;
                    if (name != null) {
                        cookieCount = Cookies.createCookie(name, cookie.substring(start, i), maxCookies, cookieCount, cookies, additional);
                    } else if (UndertowLogger.REQUEST_LOGGER.isTraceEnabled()) {
                        UndertowLogger.REQUEST_LOGGER.trace("Ignoring invalid cookies in header " + cookie);
                    }
                    state = 0;
                    start = i + 1;
                    continue block7;
                }
                case 2: {
                    if (c2 == ';' || commaIsSeperator && c2 == ',') {
                        cookieCount = Cookies.createCookie(name, cookie.substring(start, i), maxCookies, cookieCount, cookies, additional);
                        state = 0;
                        start = i + 1;
                        continue block7;
                    }
                    if (c2 == '\"' && start == i) {
                        containsEscapedQuotes = false;
                        state = 3;
                        start = i + 1;
                        continue block7;
                    }
                    if (c2 == '=') {
                        if (allowEqualInValue || allowHttpSepartorsV0) continue block7;
                        cookieCount = Cookies.createCookie(name, cookie.substring(start, i), maxCookies, cookieCount, cookies, additional);
                        state = 4;
                        start = i + 1;
                        continue block7;
                    }
                    if (c2 == ':' || allowHttpSepartorsV0 || !LegacyCookieSupport.isHttpSeparator(c2)) continue block7;
                    cookieCount = Cookies.createCookie(name, cookie.substring(start, i), maxCookies, cookieCount, cookies, additional);
                    state = 4;
                    start = i + 1;
                    continue block7;
                }
                case 3: {
                    if (c2 == '\"') {
                        cookieCount = Cookies.createCookie(name, containsEscapedQuotes ? Cookies.unescapeDoubleQuotes(cookie.substring(start, i)) : cookie.substring(start, i), maxCookies, cookieCount, cookies, additional);
                        state = 0;
                        start = i + 1;
                    } else if (c2 == ';' || commaIsSeperator && c2 == ',') {
                        state = 0;
                        start = i + 1;
                    }
                    if (c2 != '\\' || i + 1 >= cookie.length() || cookie.charAt(i + 1) != '\"' || i + 2 == cookie.length() || i + 2 < cookie.length() && (cookie.charAt(i + 2) == ';' || commaIsSeperator && cookie.charAt(i + 2) == ',')) continue block7;
                    ++i;
                    containsEscapedQuotes = true;
                    continue block7;
                }
                case 4: {
                    if (c2 == ';' || commaIsSeperator && c2 == ',') {
                        state = 0;
                    }
                    start = i + 1;
                }
            }
        }
        if (state == 2) {
            Cookies.createCookie(name, cookie.substring(start), maxCookies, cookieCount, cookies, additional);
        }
        for (Map.Entry entry : cookies.entrySet()) {
            String path;
            String version;
            c = new CookieImpl((String)entry.getKey(), (String)entry.getValue());
            String domain = (String)additional.get(DOMAIN);
            if (domain != null) {
                c.setDomain(domain);
            }
            if ((version = (String)additional.get(VERSION)) != null) {
                c.setVersion(Integer.parseInt(version));
            }
            if ((path = (String)additional.get(PATH)) != null) {
                c.setPath(path);
            }
            parsedCookies.add(c);
        }
        for (Map.Entry entry : additional.entrySet()) {
            if (DOMAIN.equals(entry.getKey())) {
                c = new CookieImpl(DOMAIN, (String)entry.getValue());
                parsedCookies.add(c);
                continue;
            }
            if (PATH.equals(entry.getKey())) {
                c = new CookieImpl(PATH, (String)entry.getValue());
                parsedCookies.add(c);
                continue;
            }
            if (!VERSION.equals(entry.getKey())) continue;
            c = new CookieImpl(VERSION, (String)entry.getValue());
            parsedCookies.add(c);
        }
    }

    private static int createCookie(String name, String value, int maxCookies, int cookieCount, Map<String, String> cookies, Map<String, String> additional) {
        if (!name.isEmpty() && name.charAt(0) == '$') {
            if (additional.containsKey(name)) {
                return cookieCount;
            }
            additional.put(name, value);
            return cookieCount;
        }
        if (cookieCount == maxCookies) {
            throw UndertowMessages.MESSAGES.tooManyCookies(maxCookies);
        }
        if (cookies.containsKey(name)) {
            return cookieCount;
        }
        cookies.put(name, value);
        return ++cookieCount;
    }

    private static String unescapeDoubleQuotes(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        char[] tmp = new char[value.length()];
        int dest = 0;
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == '\\' && i + 1 < value.length() && value.charAt(i + 1) == '\"') {
                ++i;
            }
            tmp[dest] = value.charAt(i);
            ++dest;
        }
        return new String(tmp, 0, dest);
    }

    public static void assembleCrumbs(HeaderMap headerMap) {
        HeaderValues cookieValues = headerMap.get(Headers.COOKIE);
        if (cookieValues != null && cookieValues.size() > 1) {
            StringBuilder oreos = new StringBuilder();
            String[] _cookieValues = cookieValues.toArray();
            int slices = _cookieValues.length;
            for (String slice : _cookieValues) {
                oreos.append(slice);
                if (--slices < 1) continue;
                oreos.append(CRUMB_SEPARATOR);
            }
            cookieValues.clear();
            cookieValues.add(oreos.toString());
        }
    }

    public static void disperseCrumbs(HeaderMap headerMap) {
        HeaderValues cookieValues = headerMap.get(Headers.COOKIE);
        if (cookieValues != null && cookieValues.size() == 1 && cookieValues.getFirst().contains(CRUMB_SEPARATOR)) {
            String[] cookieJar = cookieValues.getFirst().split(CRUMB_SEPARATOR);
            headerMap.remove(Headers.COOKIE);
            for (String crumb : cookieJar) {
                headerMap.addLast(Headers.COOKIE, crumb);
            }
        }
    }

    public static List<String> getCrumbs(HeaderMap headerMap) {
        HeaderValues cookieValues = headerMap.get(Headers.COOKIE);
        if (cookieValues != null) {
            if (cookieValues.size() == 1 && cookieValues.getFirst().contains(CRUMB_SEPARATOR)) {
                String[] cookieJar = cookieValues.getFirst().split(CRUMB_SEPARATOR);
                return Arrays.asList(cookieJar);
            }
            return cookieValues;
        }
        return Collections.emptyList();
    }

    public static boolean isCrumbsAssemplyDisabled() {
        return CRUMBS_ASSEMBLY_DISABLED;
    }

    private Cookies() {
    }
}

