/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.util;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import libs.io.undertow.util.HttpString;
import libs.org.wildfly.common.Assert;

public final class HeaderValues
extends AbstractCollection<String>
implements Deque<String>,
List<String>,
RandomAccess {
    private static final String[] NO_STRINGS = new String[0];
    final HttpString key;
    byte size;
    Object value;

    HeaderValues(HttpString key) {
        this.key = key;
    }

    public HttpString getHeaderName() {
        return this.key;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        byte size = this.size;
        if (size == 0) {
            return;
        }
        this.clearInternal();
    }

    private void clearInternal() {
        Object value = this.value;
        if (value instanceof String[]) {
            Object[] strings = (String[])value;
            int len = strings.length;
            Arrays.fill(strings, 0, len, null);
        } else {
            this.value = null;
        }
        this.size = 0;
    }

    private int index(int idx) {
        assert (idx >= 0);
        assert (idx < this.size);
        int len = ((String[])this.value).length;
        if (idx > len) {
            idx -= len;
        }
        return idx;
    }

    @Override
    public ListIterator<String> listIterator() {
        return this.iterator(0, true);
    }

    @Override
    public ListIterator<String> listIterator(int index) {
        return this.iterator(index, true);
    }

    @Override
    public Iterator<String> iterator() {
        return this.iterator(0, true);
    }

    @Override
    public Iterator<String> descendingIterator() {
        return this.iterator(0, false);
    }

    private ListIterator<String> iterator(final int start, final boolean forwards) {
        return new ListIterator<String>(){
            int idx;
            int returned;
            {
                this.idx = start;
                this.returned = -1;
            }

            @Override
            public boolean hasNext() {
                return this.idx < HeaderValues.this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.idx > 0;
            }

            @Override
            public String next() {
                try {
                    if (forwards) {
                        int idx = this.idx;
                        String next = HeaderValues.this.get(idx);
                        this.returned = idx;
                        this.idx = idx + 1;
                        return next;
                    }
                    int idx = this.idx - 1;
                    String next = HeaderValues.this.get(idx);
                    this.idx = this.returned = idx;
                    return next;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public int nextIndex() {
                return this.idx;
            }

            @Override
            public String previous() {
                try {
                    if (!forwards) {
                        int idx = this.idx;
                        String prev = HeaderValues.this.get(idx);
                        this.returned = idx;
                        this.idx = idx + 1;
                        return prev;
                    }
                    int idx = this.idx - 1;
                    String prev = HeaderValues.this.get(idx);
                    this.idx = this.returned = idx;
                    return prev;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public int previousIndex() {
                return this.idx - 1;
            }

            @Override
            public void remove() {
                if (this.returned == -1) {
                    throw new IllegalStateException();
                }
                HeaderValues.this.remove(this.returned);
                this.returned = -1;
            }

            @Override
            public void set(String headerValue) {
                if (this.returned == -1) {
                    throw new IllegalStateException();
                }
                HeaderValues.this.set(this.returned, headerValue);
            }

            @Override
            public void add(String headerValue) {
                if (this.returned == -1) {
                    throw new IllegalStateException();
                }
                int idx = this.idx;
                HeaderValues.this.add(idx, headerValue);
                this.idx = idx + 1;
                this.returned = -1;
            }
        };
    }

    @Override
    public boolean offerFirst(String headerValue) {
        byte size = this.size;
        if (headerValue == null || size == 127) {
            return false;
        }
        Object value = this.value;
        if (value instanceof String[]) {
            String[] strings = (String[])value;
            int len = strings.length;
            if (size == len) {
                String[] newStrings = new String[len + 2];
                System.arraycopy(strings, 0, newStrings, 1, len);
                newStrings[0] = headerValue;
                this.value = newStrings;
            } else {
                System.arraycopy(strings, 0, strings, 1, strings.length - 1);
                strings[0] = headerValue;
            }
            this.size = (byte)(size + 1);
        } else if (size == 0) {
            this.value = headerValue;
            this.size = 1;
        } else {
            this.value = new String[]{headerValue, (String)value, null, null};
            this.size = (byte)2;
        }
        return true;
    }

    @Override
    public boolean offerLast(String headerValue) {
        byte size = this.size;
        if (headerValue == null || size == 127) {
            return false;
        }
        Object value = this.value;
        if (value instanceof String[]) {
            this.offerLastMultiValue(headerValue, size, (String[])value);
        } else if (size == 0) {
            this.value = headerValue;
            this.size = 1;
        } else {
            this.value = new String[]{(String)value, headerValue, null, null};
            this.size = (byte)2;
        }
        return true;
    }

    private void offerLastMultiValue(String headerValue, int size, String[] value) {
        String[] strings = value;
        int len = strings.length;
        if (size == len) {
            String[] newStrings = new String[len + 2];
            System.arraycopy(strings, 0, newStrings, 0, len);
            newStrings[len] = headerValue;
            this.value = newStrings;
        } else {
            strings[size] = headerValue;
        }
        this.size = (byte)(size + 1);
    }

    private boolean offer(int idx, String headerValue) {
        byte size = this.size;
        if (idx < 0 || idx > size || size == 127 || headerValue == null) {
            return false;
        }
        if (idx == 0) {
            return this.offerFirst(headerValue);
        }
        if (idx == size) {
            return this.offerLast(headerValue);
        }
        assert (size >= 2);
        Object value = this.value;
        assert (value instanceof String[]);
        String[] strings = (String[])value;
        int len = strings.length;
        if (size == len) {
            int newLen = len + 2;
            String[] newStrings = new String[newLen];
            System.arraycopy(value, 0, newStrings, 0, idx);
            System.arraycopy(value, idx, newStrings, idx + 1, len - idx);
            newStrings[idx] = headerValue;
            this.value = newStrings;
        } else {
            System.arraycopy(value, idx, value, idx + 1, len - idx);
            strings[idx] = headerValue;
        }
        this.size = (byte)(size + 1);
        return true;
    }

    @Override
    public String pollFirst() {
        byte size = this.size;
        if (size == 0) {
            return null;
        }
        Object value = this.value;
        if (value instanceof String) {
            this.size = 0;
            this.value = null;
            return (String)value;
        }
        String[] strings = (String[])value;
        String ret = strings[0];
        System.arraycopy(strings, 1, strings, 0, strings.length - 1);
        this.size = (byte)(size - 1);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String pollLast() {
        byte size = this.size;
        if (size == 0) {
            return null;
        }
        Object value = this.value;
        if (value instanceof String) {
            this.size = 0;
            this.value = null;
            return (String)value;
        }
        this.size = size - 1;
        int idx = this.size;
        String[] strings = (String[])value;
        int len = strings.length;
        if (idx > len) {
            idx -= len;
        }
        try {
            String string = strings[idx];
            return string;
        }
        finally {
            strings[idx] = null;
        }
    }

    @Override
    public String remove(int idx) {
        byte size = this.size;
        if (idx < 0 || idx >= size) {
            throw new IndexOutOfBoundsException();
        }
        if (idx == 0) {
            return this.removeFirst();
        }
        if (idx == size - 1) {
            return this.removeLast();
        }
        assert (size > 2);
        String[] value = (String[])this.value;
        int len = value.length;
        String ret = value[idx];
        System.arraycopy(value, idx + 1, value, idx, len - idx - 1);
        value[len - 1] = null;
        this.size = (byte)(size - 1);
        return ret;
    }

    @Override
    public String get(int idx) {
        if (idx > this.size) {
            throw new IndexOutOfBoundsException();
        }
        Object value = this.value;
        assert (value != null);
        if (value instanceof String) {
            assert (this.size == 1);
            return (String)value;
        }
        String[] a = (String[])value;
        return a[this.index(idx)];
    }

    @Override
    public int indexOf(Object o) {
        if (o == null || this.size == 0) {
            return -1;
        }
        if (this.value instanceof String[]) {
            String[] list = (String[])this.value;
            int len = list.length;
            for (int i = 0; i < this.size; ++i) {
                if (!(i > len ? list[i - len] : list[i]).equals(o)) continue;
                return i;
            }
        } else if (o.equals(this.value)) {
            return 0;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null || this.size == 0) {
            return -1;
        }
        if (this.value instanceof String[]) {
            String[] list = (String[])this.value;
            int len = list.length;
            for (int i = this.size - 1; i >= 0; --i) {
                int idx = i;
                if (!(idx > len ? list[idx - len] : list[idx]).equals(o)) continue;
                return i;
            }
        } else if (o.equals(this.value)) {
            return 0;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String set(int index, String element) {
        Assert.checkNotNullParam("element", element);
        byte size = this.size;
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException();
        }
        Object value = this.value;
        if (size == 1 && value instanceof String) {
            try {
                String string = (String)value;
                return string;
            }
            finally {
                this.value = element;
            }
        }
        String[] list = (String[])value;
        int i = this.index(index);
        try {
            String string = list[i];
            return string;
        }
        finally {
            list[i] = element;
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends String> c) {
        byte size = this.size;
        if (index < 0 || index > size) {
            throw new IndexOutOfBoundsException();
        }
        Iterator<? extends String> iterator = c.iterator();
        boolean result = false;
        while (iterator.hasNext()) {
            result |= this.offer(index, iterator.next());
        }
        return result;
    }

    @Override
    public List<String> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        int len = toIndex - fromIndex;
        String[] strings = new String[len];
        for (int i = 0; i < len; ++i) {
            strings[i] = this.get(i + fromIndex);
        }
        return Arrays.asList(strings);
    }

    public String[] toArray() {
        byte size = this.size;
        if (size == 0) {
            return NO_STRINGS;
        }
        Object v = this.value;
        if (v instanceof String) {
            return new String[]{(String)v};
        }
        byte copyEnd = size;
        String[] list = (String[])v;
        int len = list.length;
        if (copyEnd < len) {
            return Arrays.copyOfRange(list, 0, (int)copyEnd);
        }
        String[] ret = Arrays.copyOfRange(list, 0, (int)copyEnd);
        System.arraycopy(list, 0, ret, len, copyEnd - len);
        return ret;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        byte size = this.size;
        if (size == 0) {
            return a;
        }
        int inLen = a.length;
        T[] target = inLen < size ? Arrays.copyOfRange(a, inLen, inLen + size) : a;
        Object v = this.value;
        if (v instanceof String) {
            target[0] = v;
        } else {
            System.arraycopy(v, 0, target, 0, size);
        }
        return target;
    }

    @Override
    public void addFirst(String s) {
        if (s == null) {
            return;
        }
        if (!this.offerFirst(s)) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void addLast(String s) {
        if (s == null) {
            return;
        }
        if (!this.offerLast(s)) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void add(int index, String s) {
        if (s == null) {
            return;
        }
        if (!this.offer(index, s)) {
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public String peekFirst() {
        return this.size == 0 ? null : this.get(0);
    }

    @Override
    public String peekLast() {
        return this.size == 0 ? null : this.get(this.size - 1);
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        int i = this.indexOf(o);
        return i != -1 && this.remove(i) != null;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        int i = this.lastIndexOf(o);
        return i != -1 && this.remove(i) != null;
    }

    @Override
    public boolean add(String s) {
        this.addLast(s);
        return true;
    }

    @Override
    public void push(String s) {
        this.addFirst(s);
    }

    @Override
    public String pop() {
        return this.removeFirst();
    }

    @Override
    public boolean offer(String s) {
        return this.offerLast(s);
    }

    @Override
    public String poll() {
        return this.pollFirst();
    }

    @Override
    public String peek() {
        return this.peekFirst();
    }

    @Override
    public String remove() {
        return this.removeFirst();
    }

    @Override
    public String removeFirst() {
        String s = this.pollFirst();
        if (s == null) {
            throw new NoSuchElementException();
        }
        return s;
    }

    @Override
    public String removeLast() {
        String s = this.pollLast();
        if (s == null) {
            throw new NoSuchElementException();
        }
        return s;
    }

    @Override
    public String getFirst() {
        String s = this.peekFirst();
        if (s == null) {
            throw new NoSuchElementException();
        }
        return s;
    }

    @Override
    public String getLast() {
        String s = this.peekLast();
        if (s == null) {
            throw new NoSuchElementException();
        }
        return s;
    }

    @Override
    public String element() {
        return this.getFirst();
    }

    @Override
    public boolean remove(Object obj) {
        return this.removeFirstOccurrence(obj);
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        for (String string : c) {
            this.add(string);
        }
        return !c.isEmpty();
    }

    @Override
    public HeaderValues reversed() {
        throw new UnsupportedOperationException();
    }
}

