/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.websockets.client;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import libs.io.undertow.connector.ByteBufferPool;
import libs.io.undertow.websockets.client.WebSocket13ClientHandshake;
import libs.io.undertow.websockets.client.WebSocketClientNegotiation;
import libs.io.undertow.websockets.core.WebSocketChannel;
import libs.io.undertow.websockets.core.WebSocketVersion;
import libs.io.undertow.websockets.extensions.ExtensionHandshake;
import libs.org.xnio.OptionMap;
import libs.org.xnio.StreamConnection;
import libs.org.xnio.http.ExtendedHandshakeChecker;

public abstract class WebSocketClientHandshake {
    protected final URI url;

    public static WebSocketClientHandshake create(WebSocketVersion version, URI uri) {
        return WebSocketClientHandshake.create(version, uri, null, null);
    }

    public static WebSocketClientHandshake create(WebSocketVersion version, URI uri, WebSocketClientNegotiation clientNegotiation, Set<ExtensionHandshake> extensions) {
        switch (version) {
            case V13: {
                return new WebSocket13ClientHandshake(uri, clientNegotiation, extensions);
            }
        }
        throw new IllegalArgumentException();
    }

    public WebSocketClientHandshake(URI url) {
        this.url = url;
    }

    public abstract WebSocketChannel createChannel(StreamConnection var1, String var2, ByteBufferPool var3, OptionMap var4);

    public abstract Map<String, String> createHeaders();

    public abstract ExtendedHandshakeChecker handshakeChecker(URI var1, Map<String, List<String>> var2);
}

