/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.websockets.core.protocol.version07;

import java.nio.ByteBuffer;
import libs.io.undertow.server.protocol.framed.FrameHeaderData;
import libs.io.undertow.websockets.core.function.ChannelFunction;
import libs.io.undertow.websockets.core.protocol.version07.WebSocket07Channel;

public final class Masker
implements ChannelFunction {
    private byte[] maskingKey;
    int m;

    Masker(int maskingKey) {
        this.maskingKey = Masker.createsMaskingKey(maskingKey);
    }

    public void setMaskingKey(int maskingKey) {
        this.maskingKey = Masker.createsMaskingKey(maskingKey);
        this.m = 0;
    }

    private static byte[] createsMaskingKey(int maskingKey) {
        byte[] key = new byte[]{(byte)(maskingKey >> 24 & 0xFF), (byte)(maskingKey >> 16 & 0xFF), (byte)(maskingKey >> 8 & 0xFF), (byte)(maskingKey & 0xFF)};
        return key;
    }

    private void mask(ByteBuffer buf, int position, int length) {
        int limit = position + length;
        for (int i = position; i < limit; ++i) {
            buf.put(i, (byte)(buf.get(i) ^ this.maskingKey[this.m++]));
            this.m %= 4;
        }
    }

    @Override
    public void newFrame(FrameHeaderData headerData) {
        WebSocket07Channel.WebSocketFrameHeader header = (WebSocket07Channel.WebSocketFrameHeader)headerData;
        this.setMaskingKey(header.getMaskingKey());
    }

    @Override
    public void afterRead(ByteBuffer buf, int position, int length) {
        this.mask(buf, position, length);
    }

    @Override
    public void beforeWrite(ByteBuffer buf, int position, int length) {
        this.mask(buf, position, length);
    }

    @Override
    public void complete() {
    }
}

