/*
 * Decompiled with CFR 0.152.
 */
package libs.net.querz.io;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import libs.net.querz.io.Deserializer;

public interface StringDeserializer<T>
extends Deserializer<T> {
    public T fromReader(Reader var1) throws IOException;

    default public T fromString(String s) throws IOException {
        return this.fromReader(new StringReader(s));
    }

    @Override
    default public T fromStream(InputStream stream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(stream);){
            T t = this.fromReader(reader);
            return t;
        }
    }

    @Override
    default public T fromFile(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            T t = this.fromReader(reader);
            return t;
        }
    }

    @Override
    default public T fromBytes(byte[] data) throws IOException {
        return this.fromReader(new StringReader(new String(data)));
    }
}

