/*
 * Decompiled with CFR 0.152.
 */
package libs.net.querz.nbt.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import libs.net.querz.io.Deserializer;
import libs.net.querz.io.MaxDepthIO;
import libs.net.querz.nbt.io.LittleEndianNBTInputStream;
import libs.net.querz.nbt.io.NBTInputStream;
import libs.net.querz.nbt.io.NamedTag;

public class NBTDeserializer
implements Deserializer<NamedTag> {
    private boolean compressed;
    private boolean littleEndian;

    public NBTDeserializer() {
        this(true);
    }

    public NBTDeserializer(boolean compressed) {
        this.compressed = compressed;
    }

    public NBTDeserializer(boolean compressed, boolean littleEndian) {
        this.compressed = compressed;
        this.littleEndian = littleEndian;
    }

    @Override
    public NamedTag fromStream(InputStream stream) throws IOException {
        InputStream input = this.compressed ? new GZIPInputStream(stream) : stream;
        MaxDepthIO nbtIn = this.littleEndian ? new LittleEndianNBTInputStream(input) : new NBTInputStream(input);
        return nbtIn.readTag(512);
    }
}

