/*
 * Decompiled with CFR 0.152.
 */
package libs.org.wildfly.common.iteration;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public class CompositeIterator<E>
implements Iterator<E> {
    private final Iterable<? extends Iterator<? extends E>> iterators;
    private Iterator<? extends E> lastIterator;

    @SafeVarargs
    public CompositeIterator(Iterator<? extends E> ... iterators) {
        this(Arrays.asList(iterators));
    }

    public CompositeIterator(Iterable<? extends Iterator<? extends E>> iterators) {
        this.iterators = iterators;
    }

    @Override
    public boolean hasNext() {
        for (Iterator<E> iterator : this.iterators) {
            if (!iterator.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public E next() {
        for (Iterator<E> iterator : this.iterators) {
            if (!iterator.hasNext()) continue;
            this.lastIterator = iterator;
            return iterator.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        Iterator<E> iterator = this.lastIterator;
        if (iterator == null) {
            throw new IllegalStateException();
        }
        iterator.remove();
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        for (Iterator<E> iterator : this.iterators) {
            while (iterator.hasNext()) {
                action.accept(iterator.next());
            }
        }
    }
}

