/*
 * Decompiled with CFR 0.152.
 */
package libs.org.wildfly.common.iteration;

import java.util.NoSuchElementException;
import libs.org.wildfly.common.iteration.ByteIterator;

final class LimitedByteIterator
extends ByteIterator {
    private final ByteIterator iter;
    private final long size;
    long offset;

    LimitedByteIterator(ByteIterator iter, long size) {
        this.iter = iter;
        this.size = size;
        this.offset = 0L;
    }

    @Override
    public boolean hasNext() {
        return this.offset < this.size && this.iter.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        return this.offset > 0L;
    }

    @Override
    public int next() {
        if (this.offset == this.size) {
            throw new NoSuchElementException();
        }
        ++this.offset;
        return this.iter.next();
    }

    @Override
    public int peekNext() throws NoSuchElementException {
        if (this.offset == this.size) {
            throw new NoSuchElementException();
        }
        return this.iter.peekNext();
    }

    @Override
    public int previous() {
        if (this.offset == 0L) {
            throw new NoSuchElementException();
        }
        --this.offset;
        return this.iter.previous();
    }

    @Override
    public int peekPrevious() throws NoSuchElementException {
        if (this.offset == 0L) {
            throw new NoSuchElementException();
        }
        return this.iter.peekPrevious();
    }

    @Override
    public int drain(byte[] dst, int offs, int len) {
        return super.drain(dst, offs, (int)Math.min((long)len, this.size - this.offset));
    }

    @Override
    public long getIndex() {
        return this.offset;
    }
}

