/*
 * Decompiled with CFR 0.152.
 */
package libs.org.wildfly.common.iteration;

import java.util.NoSuchElementException;
import libs.org.wildfly.common.iteration.CodePointIterator;

final class StringIterator
extends CodePointIterator {
    private final int len;
    private final String string;
    private final int offs;
    private int idx;
    private long offset;

    StringIterator(int len, String string, int offs) {
        this.len = len;
        this.string = string;
        this.offs = offs;
        this.idx = 0;
        this.offset = 0L;
    }

    @Override
    public boolean hasNext() {
        return this.idx < this.len;
    }

    @Override
    public boolean hasPrevious() {
        return this.offset > 0L;
    }

    @Override
    public int next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            ++this.offset;
            int n = this.string.codePointAt(this.idx + this.offs);
            return n;
        }
        finally {
            this.idx = this.string.offsetByCodePoints(this.idx + this.offs, 1) - this.offs;
        }
    }

    @Override
    public int peekNext() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.string.codePointAt(this.idx + this.offs);
    }

    @Override
    public int previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        this.idx = this.string.offsetByCodePoints(this.idx + this.offs, -1) - this.offs;
        --this.offset;
        return this.string.codePointAt(this.idx + this.offs);
    }

    @Override
    public int peekPrevious() throws NoSuchElementException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return this.string.codePointBefore(this.idx + this.offs);
    }

    @Override
    public long getIndex() {
        return this.offset;
    }

    @Override
    public StringBuilder drainTo(StringBuilder b) {
        try {
            StringBuilder stringBuilder = b.append(this.string, this.idx + this.offs, this.offs + this.len);
            return stringBuilder;
        }
        finally {
            this.offset += (long)this.string.codePointCount(this.idx + this.offs, this.offs + this.len);
            this.idx = this.len;
        }
    }

    @Override
    public String drainToString() {
        try {
            String string = this.string.substring(this.idx + this.offs, this.offs + this.len);
            return string;
        }
        finally {
            this.offset += (long)this.string.codePointCount(this.idx + this.offs, this.offs + this.len);
            this.idx = this.len;
        }
    }
}

