/*
 * Decompiled with CFR 0.152.
 */
package libs.org.wildfly.common.lock;

import io.smallrye.common.cpu.ProcessorInfo;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.security.AccessController;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import libs.org.wildfly.common.Assert;
import libs.org.wildfly.common.lock.ExtendedLock;

public class SpinLock
implements ExtendedLock {
    private final VarHandle ownerHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "owner", VarHandle.class, SpinLock.class, Thread.class);
    private static final int defaultSpinLimit = AccessController.doPrivileged(() -> Integer.valueOf(System.getProperty("jboss.spin-lock.limit", ProcessorInfo.availableProcessors() == 1 ? "0" : "5000")));
    private volatile Thread owner;
    private int level;
    private final int spinLimit;

    public SpinLock() {
        this(defaultSpinLimit);
    }

    public SpinLock(int spinLimit) {
        Assert.checkMinimumParameter("spinLimit", 0, spinLimit);
        this.spinLimit = spinLimit;
    }

    @Override
    public boolean isLocked() {
        return this.owner != null;
    }

    @Override
    public boolean isHeldByCurrentThread() {
        return this.owner == Thread.currentThread();
    }

    @Override
    public boolean isFair() {
        return true;
    }

    @Override
    public void lock() {
        int spins = 0;
        while (true) {
            Thread owner;
            if ((owner = this.owner) == Thread.currentThread()) {
                ++this.level;
                return;
            }
            if (owner == null && this.trySetOwner()) {
                this.level = 1;
                return;
            }
            if (spins >= this.spinLimit) {
                Thread.yield();
                continue;
            }
            Thread.onSpinWait();
            ++spins;
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        int spins = 0;
        while (true) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread owner = this.owner;
            if (owner == Thread.currentThread()) {
                ++this.level;
                return;
            }
            if (owner == null && this.trySetOwner()) {
                this.level = 1;
                return;
            }
            if (spins >= this.spinLimit) {
                Thread.yield();
                continue;
            }
            Thread.onSpinWait();
            ++spins;
        }
    }

    @Override
    public boolean tryLock() {
        Thread owner = this.owner;
        if (owner == Thread.currentThread()) {
            ++this.level;
            return true;
        }
        if (owner == null && this.trySetOwner()) {
            this.level = 1;
            return true;
        }
        return false;
    }

    @Override
    public void unlock() {
        Thread owner = this.owner;
        if (owner == Thread.currentThread()) {
            if (--this.level == 0) {
                this.owner = null;
            }
        } else {
            throw new IllegalMonitorStateException();
        }
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws UnsupportedOperationException {
        throw Assert.unsupported();
    }

    @Override
    public Condition newCondition() throws UnsupportedOperationException {
        throw Assert.unsupported();
    }

    private boolean trySetOwner() {
        return this.ownerHandle.compareAndSet(this, null, Thread.currentThread());
    }
}

