/*
 * Decompiled with CFR 0.152.
 */
package libs.org.xnio;

import libs.org.xnio.ChannelListener;
import libs.org.xnio.ChannelListeners;
import libs.org.xnio.Connection;
import libs.org.xnio.XnioIoThread;
import libs.org.xnio._private.Messages;
import libs.org.xnio.channels.CloseListenerSettable;
import libs.org.xnio.conduits.ConduitReadableMessageChannel;
import libs.org.xnio.conduits.ConduitWritableMessageChannel;
import libs.org.xnio.conduits.MessageSinkConduit;
import libs.org.xnio.conduits.MessageSourceConduit;

public abstract class MessageConnection
extends Connection
implements CloseListenerSettable<MessageConnection> {
    private ConduitReadableMessageChannel sourceChannel;
    private ConduitWritableMessageChannel sinkChannel;
    private ChannelListener<? super MessageConnection> closeListener;

    protected MessageConnection(XnioIoThread thread) {
        super(thread);
    }

    @Override
    public void setCloseListener(ChannelListener<? super MessageConnection> listener) {
        this.closeListener = listener;
    }

    @Override
    public ChannelListener<? super MessageConnection> getCloseListener() {
        return this.closeListener;
    }

    public ChannelListener.Setter<MessageConnection> getCloseSetter() {
        return new CloseListenerSettable.Setter<MessageConnection>(this);
    }

    protected void setSourceConduit(MessageSourceConduit conduit) {
        this.sourceChannel = conduit == null ? null : new ConduitReadableMessageChannel(this, conduit);
    }

    protected void setSinkConduit(MessageSinkConduit conduit) {
        this.sinkChannel = conduit == null ? null : new ConduitWritableMessageChannel(this, conduit);
    }

    @Override
    void invokeCloseListener() {
        ChannelListeners.invokeChannelListener(this, this.closeListener);
    }

    private static <T> T notNull(T orig) throws IllegalStateException {
        if (orig == null) {
            throw Messages.msg.channelNotAvailable();
        }
        return orig;
    }

    public ConduitReadableMessageChannel getSourceChannel() {
        return MessageConnection.notNull(this.sourceChannel);
    }

    public ConduitWritableMessageChannel getSinkChannel() {
        return MessageConnection.notNull(this.sinkChannel);
    }
}

