/*
 * Decompiled with CFR 0.152.
 */
package libs.org.xnio;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import libs.org.jboss.logging.Logger;
import libs.org.xnio.ChannelListener;
import libs.org.xnio.ChannelListeners;
import libs.org.xnio.Connection;
import libs.org.xnio.XnioIoThread;
import libs.org.xnio._private.Messages;
import libs.org.xnio.channels.CloseListenerSettable;
import libs.org.xnio.conduits.ConduitStreamSinkChannel;
import libs.org.xnio.conduits.ConduitStreamSourceChannel;
import libs.org.xnio.conduits.StreamSinkConduit;
import libs.org.xnio.conduits.StreamSourceConduit;

public abstract class StreamConnection
extends Connection
implements CloseListenerSettable<StreamConnection> {
    private static final ChannelListener<? super StreamConnection> INVOKED_CLOSE_LISTENER_FLAG = connection -> {};
    private static final Logger log = Logger.getLogger("libs.org.xnio.StreamConnection");
    private ConduitStreamSourceChannel sourceChannel;
    private ConduitStreamSinkChannel sinkChannel;
    private AtomicReference<ChannelListener<? super StreamConnection>> closeListener = new AtomicReference();

    protected StreamConnection(XnioIoThread thread) {
        super(thread);
    }

    @Override
    public void setCloseListener(ChannelListener<? super StreamConnection> listener) {
        ChannelListener<? super StreamConnection> newListener;
        ChannelListener<? super StreamConnection> currentListener;
        do {
            newListener = listener;
            currentListener = this.closeListener.get();
            if (currentListener == null) continue;
            if (currentListener == INVOKED_CLOSE_LISTENER_FLAG) {
                ChannelListeners.invokeChannelListener(this, listener);
                return;
            }
            newListener = this.mergeListeners(currentListener, listener);
        } while (!this.closeListener.compareAndSet(currentListener, newListener));
    }

    private final ChannelListener<? super StreamConnection> mergeListeners(ChannelListener<? super StreamConnection> listener1, ChannelListener<? super StreamConnection> listener2) {
        return channel -> {
            listener1.handleEvent((StreamConnection)channel);
            listener2.handleEvent((StreamConnection)channel);
        };
    }

    @Override
    protected void notifyReadClosed() {
        try {
            this.getSourceChannel().shutdownReads();
        }
        catch (IOException e) {
            Messages.msg.connectionNotifyReadClosedFailed(e, this);
        }
    }

    @Override
    protected void notifyWriteClosed() {
        try {
            this.getSinkChannel().shutdownWrites();
        }
        catch (IOException e) {
            Messages.msg.connectionNotifyWriteClosedFailed(e, this);
        }
    }

    @Override
    public ChannelListener<? super StreamConnection> getCloseListener() {
        return this.closeListener.get();
    }

    public ChannelListener.Setter<? extends StreamConnection> getCloseSetter() {
        return new CloseListenerSettable.Setter<StreamConnection>(this);
    }

    protected void setSourceConduit(StreamSourceConduit conduit) {
        this.sourceChannel = conduit == null ? null : new ConduitStreamSourceChannel(this, conduit);
    }

    protected void setSinkConduit(StreamSinkConduit conduit) {
        this.sinkChannel = conduit == null ? null : new ConduitStreamSinkChannel(this, conduit);
    }

    @Override
    void invokeCloseListener() {
        ChannelListener<? super StreamConnection> listener = this.closeListener.getAndSet(INVOKED_CLOSE_LISTENER_FLAG);
        ChannelListeners.invokeChannelListener(this, listener);
    }

    private static <T> T notNull(T orig) throws IllegalStateException {
        if (orig == null) {
            throw Messages.msg.channelNotAvailable();
        }
        return orig;
    }

    public ConduitStreamSourceChannel getSourceChannel() {
        return StreamConnection.notNull(this.sourceChannel);
    }

    public ConduitStreamSinkChannel getSinkChannel() {
        return StreamConnection.notNull(this.sinkChannel);
    }
}

