/*
 * Decompiled with CFR 0.152.
 */
package libs.org.xnio;

import libs.org.xnio.Option;
import libs.org.xnio._private.Messages;

final class TypeOption<T>
extends Option<Class<? extends T>> {
    private static final long serialVersionUID = 2449094406108952764L;
    private final transient Class<T> type;
    private final transient Option.ValueParser<Class<? extends T>> parser;

    TypeOption(Class<?> declClass, String name, Class<T> type) {
        super(declClass, name);
        if (type == null) {
            throw Messages.msg.nullParameter("type");
        }
        this.type = type;
        this.parser = Option.getClassParser(type);
    }

    @Override
    public Class<? extends T> cast(Object o) {
        return ((Class)o).asSubclass(this.type);
    }

    @Override
    public Class<? extends T> parseValue(String string, ClassLoader classLoader) throws IllegalArgumentException {
        return this.parser.parseValue(string, classLoader);
    }
}

