/*
 * Decompiled with CFR 0.152.
 */
package libs.org.xnio.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import libs.org.xnio.Buffers;
import libs.org.xnio.Pooled;
import libs.org.xnio.channels.StreamSourceChannel;
import libs.org.xnio.conduits.AbstractStreamSinkConduit;
import libs.org.xnio.conduits.Conduits;
import libs.org.xnio.conduits.StreamSinkConduit;

public final class BufferedStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private final Pooled<ByteBuffer> pooledBuffer;
    private boolean terminate;

    public BufferedStreamSinkConduit(StreamSinkConduit next, Pooled<ByteBuffer> pooledBuffer) {
        super(next);
        this.pooledBuffer = pooledBuffer;
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return this.flushLocal() ? super.transferFrom(src, position, count) : 0L;
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (this.flushLocal()) {
            return super.transferFrom(source, count, throughBuffer);
        }
        throughBuffer.limit(0);
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        try {
            ByteBuffer buffer = this.pooledBuffer.getResource();
            int pos = buffer.position();
            int lim = buffer.limit();
            int srcRem = src.remaining();
            int ourRem = lim - pos;
            if (srcRem < ourRem) {
                buffer.put(src);
                return srcRem;
            }
            if (buffer.position() == 0) {
                int res = super.write(src);
                if (srcRem > res) {
                    int cnt = Buffers.copy(buffer, src);
                    return res + cnt;
                }
                return res;
            }
            buffer.flip();
            try {
                super.write(new ByteBuffer[]{buffer, src}, 0, 2);
            }
            finally {
                buffer.compact();
            }
            if (src.hasRemaining()) {
                Buffers.copy(buffer, src);
            }
            return srcRem - src.remaining();
        }
        catch (IllegalStateException ignored) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        if (len == 0) {
            return 0L;
        }
        if (len == 1) {
            return this.write(srcs[offs]);
        }
        try {
            ByteBuffer buffer = this.pooledBuffer.getResource();
            int pos = buffer.position();
            int lim = buffer.limit();
            long srcRem = Buffers.remaining(srcs, offs, len);
            int ourRem = lim - pos;
            if (srcRem < (long)ourRem) {
                for (int i = 0; i < len; ++i) {
                    buffer.put(srcs[i]);
                }
                return srcRem;
            }
            if (buffer.position() == 0) {
                long res = super.write(srcs, offs, len);
                if (srcRem > res) {
                    int cnt = Buffers.copy(buffer, srcs, offs, len);
                    return res + (long)cnt;
                }
                return res;
            }
            buffer.flip();
            try {
                ByteBuffer[] buffers;
                if (offs > 0) {
                    buffers = Arrays.copyOfRange(srcs, offs - 1, offs + len);
                } else {
                    buffers = new ByteBuffer[len + 1];
                    System.arraycopy(srcs, offs, buffers, 1, len);
                }
                buffers[0] = buffer;
                super.write(buffers, 0, buffers.length);
            }
            finally {
                buffer.compact();
            }
            Buffers.copy(buffer, srcs, offs, len);
            return srcRem - Buffers.remaining(srcs, offs, len);
        }
        catch (IllegalStateException ignored) {
            throw new ClosedChannelException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean flushLocal() throws IOException {
        boolean bl;
        ByteBuffer buffer = this.pooledBuffer.getResource();
        if (buffer.position() <= 0) return true;
        buffer.flip();
        try {
            do {
                super.write(buffer);
            } while (buffer.hasRemaining());
            if (this.terminate) {
                this.pooledBuffer.free();
            }
            bl = true;
            buffer.compact();
        }
        catch (Throwable throwable) {
            try {
                buffer.compact();
                throw throwable;
            }
            catch (IllegalStateException ignored) {
                return true;
            }
        }
        return bl;
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic(this, src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic(this, srcs, offset, length);
    }

    @Override
    public boolean flush() throws IOException {
        return this.flushLocal() && super.flush();
    }

    @Override
    public void truncateWrites() throws IOException {
        this.pooledBuffer.free();
        super.truncateWrites();
    }

    @Override
    public void terminateWrites() throws IOException {
        this.terminate = true;
        super.terminateWrites();
    }
}

