/*
 * Decompiled with CFR 0.152.
 */
package libs.org.xnio.conduits;

import libs.org.xnio.ChannelListener;
import libs.org.xnio.ChannelListeners;
import libs.org.xnio.IoUtils;
import libs.org.xnio.channels.CloseListenerSettable;
import libs.org.xnio.channels.SuspendableWriteChannel;
import libs.org.xnio.channels.WriteListenerSettable;
import libs.org.xnio.conduits.TerminateHandler;

public interface WriteReadyHandler
extends TerminateHandler {
    public void writeReady();

    public static class ReadyTask
    implements Runnable {
        private final WriteReadyHandler handler;

        public ReadyTask(WriteReadyHandler handler) {
            this.handler = handler;
        }

        @Override
        public void run() {
            this.handler.writeReady();
        }
    }

    public static class ChannelListenerHandler<C extends SuspendableWriteChannel & WriteListenerSettable<C>>
    implements WriteReadyHandler {
        private final C channel;

        public ChannelListenerHandler(C channel) {
            this.channel = channel;
        }

        @Override
        public void forceTermination() {
            IoUtils.safeClose(this.channel);
        }

        @Override
        public void writeReady() {
            ChannelListener writeListener = ((WriteListenerSettable)this.channel).getWriteListener();
            if (writeListener == null) {
                this.channel.suspendWrites();
            } else {
                ChannelListeners.invokeChannelListener(this.channel, writeListener);
            }
        }

        @Override
        public void terminated() {
            ChannelListeners.invokeChannelListener(this.channel, ((CloseListenerSettable)this.channel).getCloseListener());
        }
    }
}

