/*
 * Decompiled with CFR 0.152.
 */
package libs.org.xnio.nio;

import java.io.Closeable;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import libs.org.xnio.Bits;
import libs.org.xnio.ChannelListeners;
import libs.org.xnio.IoUtils;
import libs.org.xnio.nio.NioHandle;
import libs.org.xnio.nio.NioUdpChannel;
import libs.org.xnio.nio.WorkerThread;

final class NioUdpChannelHandle
extends NioHandle {
    private final NioUdpChannel channel;

    NioUdpChannelHandle(WorkerThread workerThread, SelectionKey selectionKey, NioUdpChannel channel) {
        super(workerThread, selectionKey);
        this.channel = channel;
    }

    @Override
    void handleReady(int ops) {
        try {
            if (ops == 0) {
                SelectionKey key = this.getSelectionKey();
                int interestOps = key.interestOps();
                if (interestOps != 0) {
                    ops = interestOps;
                } else {
                    this.forceTermination();
                    return;
                }
            }
            if (Bits.allAreSet(ops, 1)) {
                try {
                    ChannelListeners.invokeChannelListener(this.channel, this.channel.getReadListener());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (Bits.allAreSet(ops, 4)) {
                try {
                    ChannelListeners.invokeChannelListener(this.channel, this.channel.getWriteListener());
                }
                catch (Throwable throwable) {}
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    @Override
    void forceTermination() {
        IoUtils.safeClose((Closeable)this.channel);
    }

    @Override
    void terminated() {
        this.channel.invokeCloseHandler();
    }
}

