/*
 * Decompiled with CFR 0.152.
 */
package libs.org.xnio.streams;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import libs.org.xnio.Bits;
import libs.org.xnio._private.Messages;
import libs.org.xnio.channels.Channels;
import libs.org.xnio.channels.StreamSourceChannel;

public class ChannelInputStream
extends InputStream {
    protected final StreamSourceChannel channel;
    private volatile int flags;
    private volatile long timeout;
    private static final AtomicIntegerFieldUpdater<ChannelInputStream> flagsUpdater = AtomicIntegerFieldUpdater.newUpdater(ChannelInputStream.class, "flags");
    private static final int FLAG_EOF = 2;
    private static final int FLAG_ENTERED = 1;

    public ChannelInputStream(StreamSourceChannel channel) {
        if (channel == null) {
            throw Messages.msg.nullParameter("channel");
        }
        this.channel = channel;
    }

    public ChannelInputStream(StreamSourceChannel channel, long timeout, TimeUnit timeoutUnit) {
        if (channel == null) {
            throw Messages.msg.nullParameter("channel");
        }
        if (timeoutUnit == null) {
            throw Messages.msg.nullParameter("timeoutUnit");
        }
        if (timeout < 0L) {
            throw Messages.msg.parameterOutOfRange("timeout");
        }
        this.channel = channel;
        long calcTimeout = timeoutUnit.toNanos(timeout);
        this.timeout = timeout == 0L ? 0L : (calcTimeout < 1L ? 1L : calcTimeout);
    }

    private boolean enter() {
        int old = this.flags;
        do {
            if (!Bits.allAreSet(old, 1)) continue;
            throw Messages.msg.concurrentAccess();
        } while (!flagsUpdater.compareAndSet(this, old, old | 1));
        return Bits.allAreSet(old, 2);
    }

    private void exit(boolean setEof) {
        int newFlags;
        int oldFlags;
        do {
            oldFlags = this.flags;
            newFlags = oldFlags & 0xFFFFFFFE;
            if (!setEof) continue;
            newFlags |= 2;
        } while (!flagsUpdater.compareAndSet(this, oldFlags, newFlags));
    }

    public long getReadTimeout(TimeUnit unit) {
        if (unit == null) {
            throw Messages.msg.nullParameter("unit");
        }
        return unit.convert(this.timeout, TimeUnit.NANOSECONDS);
    }

    public void setReadTimeout(long timeout, TimeUnit unit) {
        if (timeout < 0L) {
            throw Messages.msg.parameterOutOfRange("timeout");
        }
        if (unit == null) {
            throw Messages.msg.nullParameter("unit");
        }
        long calcTimeout = unit.toNanos(timeout);
        this.timeout = timeout == 0L ? 0L : (calcTimeout < 1L ? 1L : calcTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        boolean eof = this.enter();
        try {
            if (eof) {
                int n = -1;
                return n;
            }
            byte[] array = new byte[1];
            ByteBuffer buffer = ByteBuffer.wrap(array);
            int res = this.channel.read(buffer);
            if (res == 0) {
                long start = System.nanoTime();
                long elapsed = 0L;
                do {
                    long timeout;
                    if ((timeout = this.timeout) == 0L) {
                        this.channel.awaitReadable();
                    } else {
                        if (timeout < elapsed) {
                            throw Messages.msg.readTimeout();
                        }
                        this.channel.awaitReadable(timeout - elapsed, TimeUnit.NANOSECONDS);
                    }
                    elapsed = System.nanoTime() - start;
                } while ((res = this.channel.read(buffer)) == 0);
            }
            eof = res == -1;
            int n = eof ? -1 : array[0] & 0xFF;
            return n;
        }
        finally {
            this.exit(eof);
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len < 1 || off + len > b.length) {
            return 0;
        }
        boolean eof = this.enter();
        try {
            if (eof) {
                int n = -1;
                return n;
            }
            ByteBuffer buffer = ByteBuffer.wrap(b, off, len);
            int res = this.channel.read(buffer);
            if (res == 0) {
                long start = System.nanoTime();
                long elapsed = 0L;
                do {
                    long timeout;
                    if ((timeout = this.timeout) == 0L) {
                        this.channel.awaitReadable();
                    } else {
                        if (timeout < elapsed) {
                            throw Messages.msg.readTimeout();
                        }
                        this.channel.awaitReadable(timeout - elapsed, TimeUnit.NANOSECONDS);
                    }
                    elapsed = System.nanoTime() - start;
                } while ((res = this.channel.read(buffer)) == 0);
            }
            eof = res == -1;
            int n = eof ? -1 : buffer.position() - off;
            return n;
        }
        finally {
            this.exit(eof);
        }
    }

    @Override
    public long skip(long n) throws IOException {
        if (n < 1L) {
            return 0L;
        }
        boolean eof = this.enter();
        try {
            if (eof) {
                long l = 0L;
                return l;
            }
            n = Math.min(n, Integer.MAX_VALUE);
            long total = 0L;
            long start = System.nanoTime();
            long elapsed = 0L;
            while (true) {
                if (n == 0L) {
                    long l = total;
                    return l;
                }
                long res = Channels.drain(this.channel, n);
                if (res == -1L) {
                    long l = total;
                    return l;
                }
                if (res == 0L) {
                    long timeout = this.timeout;
                    try {
                        if (timeout == 0L) {
                            this.channel.awaitReadable();
                        } else {
                            if (timeout < elapsed) {
                                throw Messages.msg.readTimeout();
                            }
                            this.channel.awaitReadable(timeout - elapsed, TimeUnit.NANOSECONDS);
                        }
                    }
                    catch (InterruptedIOException e) {
                        assert (total < Integer.MAX_VALUE);
                        e.bytesTransferred = (int)total;
                        throw e;
                    }
                    elapsed = System.nanoTime() - start;
                    continue;
                }
                total += res;
                n -= res;
            }
        }
        finally {
            this.exit(eof);
        }
    }

    @Override
    public void close() throws IOException {
        this.enter();
        try {
            this.channel.shutdownReads();
        }
        finally {
            this.exit(true);
        }
    }
}

