/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.bukkit;

import java.util.UUID;
import net.pl3x.map.bukkit.BukkitNetwork;
import net.pl3x.map.bukkit.BukkitPlayer;
import net.pl3x.map.bukkit.BukkitWorld;
import net.pl3x.map.bukkit.Pl3xMapImpl;
import net.pl3x.map.bukkit.command.BukkitCommandManager;
import net.pl3x.map.bukkit.util.SchedulerUtil;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.event.server.ServerLoadedEvent;
import net.pl3x.map.core.network.Network;
import net.pl3x.map.core.player.Player;
import net.pl3x.map.core.player.PlayerListener;
import net.pl3x.map.core.player.PlayerRegistry;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class Pl3xMapBukkit
extends JavaPlugin
implements Listener {
    private final Pl3xMapImpl pl3xmap;
    private final PlayerListener playerListener = new PlayerListener();
    private boolean isFolia = false;
    private Network network;

    public Pl3xMapBukkit() {
        this.pl3xmap = new Pl3xMapImpl(this);
    }

    public void onEnable() {
        this.pl3xmap.enable();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.network = new BukkitNetwork(this);
        this.network.register();
        try {
            new BukkitCommandManager((Plugin)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SchedulerUtil.runTaskTimer((Plugin)this, this.pl3xmap.getScheduler(), this.getServer().getScheduler());
    }

    public void onDisable() {
        if (this.network != null) {
            this.network.unregister();
            this.network = null;
        }
        this.pl3xmap.disable();
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        PlayerRegistry registry = Pl3xMap.api().getPlayerRegistry();
        UUID uuid = event.getPlayer().getUniqueId();
        Player bukkitPlayer = registry.getOrDefault(uuid, () -> new BukkitPlayer(event.getPlayer()));
        this.playerListener.onJoin(bukkitPlayer);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID uuid;
        PlayerRegistry registry = Pl3xMap.api().getPlayerRegistry();
        Player bukkitPlayer = registry.unregister(uuid = event.getPlayer().getUniqueId());
        if (bukkitPlayer != null) {
            this.playerListener.onQuit(bukkitPlayer);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldLoad(WorldLoadEvent event) {
        World world = event.getWorld();
        Pl3xMap.api().getWorldRegistry().getOrDefault(world.getName(), () -> new BukkitWorld(((CraftWorld)world).getHandle(), world.getName()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onWorldUnload(WorldUnloadEvent event) {
        Pl3xMap.api().getWorldRegistry().unregister(event.getWorld().getName());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onServerLoaded(ServerLoadEvent event) {
        Pl3xMap.api().getEventRegistry().callEvent(new ServerLoadedEvent());
    }
}

