/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.bukkit;

import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.platform.AudienceProvider;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.BlockRedstoneWire;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureRandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.pl3x.map.bukkit.BukkitPlayer;
import net.pl3x.map.bukkit.BukkitWorld;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.world.Biome;
import net.pl3x.map.core.world.Block;
import net.pl3x.map.core.world.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class Pl3xMapImpl
extends Pl3xMap {
    private final RandomSource randomSource = RandomSource.b();
    private final JavaPlugin plugin;
    private BukkitAudiences adventure;
    private Path jarPath;

    public Pl3xMapImpl(JavaPlugin plugin) {
        super(true);
        this.plugin = plugin;
    }

    @Override
    public void enable() {
        this.adventure = BukkitAudiences.create((Plugin)this.plugin);
        super.enable();
    }

    @Override
    public void disable() {
        super.disable();
        if (this.adventure != null) {
            this.adventure.close();
            this.adventure = null;
        }
    }

    @Override
    public String getPlatform() {
        String name = Bukkit.getName();
        if ("CraftBukkit".equals(name)) {
            try {
                Class.forName("org.spigotmc.SpigotConfig");
                return "spigot";
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return name.toLowerCase(Locale.ROOT);
    }

    @Override
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    @Override
    public int getMaxPlayers() {
        return Bukkit.getMaxPlayers();
    }

    @Override
    public boolean getOnlineMode() {
        return Bukkit.getOnlineMode();
    }

    @Override
    public String getServerVersion() {
        return Bukkit.getVersion();
    }

    @Override
    public AudienceProvider adventure() {
        if (this.adventure == null) {
            throw new IllegalStateException("Tried to access Adventure without a running server!");
        }
        return this.adventure;
    }

    @Override
    public Path getMainDir() {
        return this.plugin.getDataFolder().toPath();
    }

    @Override
    public Path getJarPath() {
        if (this.jarPath == null) {
            try {
                this.jarPath = Path.of(Pl3xMap.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return this.jarPath;
    }

    @Override
    public int getColorForPower(byte power) {
        return BlockRedstoneWire.b((int)power);
    }

    @Override
    public @Nullable Block getFlower(World world, Biome biome, int blockX, int blockY, int blockZ) {
        BiomeBase nms = (BiomeBase)((WorldServer)world.getLevel()).L_().f(Registries.aN).a(MinecraftKey.a((String)biome.getKey()));
        if (nms == null) {
            return null;
        }
        List flowers = nms.d().b();
        if (flowers.isEmpty()) {
            return null;
        }
        WorldGenFeatureRandomPatchConfiguration config = (WorldGenFeatureRandomPatchConfiguration)((WorldGenFeatureConfigured)flowers.getFirst()).c();
        WorldGenFeatureBlockConfiguration flower = (WorldGenFeatureBlockConfiguration)((WorldGenFeatureConfigured)((PlacedFeature)config.d().a()).b().a()).c();
        net.minecraft.world.level.block.Block block = flower.a().a(this.randomSource, new BlockPosition(blockX, blockY, blockZ)).b();
        return this.getBlockRegistry().get(BuiltInRegistries.e.b((Object)block).toString());
    }

    @Override
    protected void loadBlocks() {
        Set entries = MinecraftServer.getServer().bg().f(Registries.i).k();
        for (Map.Entry entry : entries) {
            String id = ((ResourceKey)entry.getKey()).a().toString();
            int color = ((net.minecraft.world.level.block.Block)entry.getValue()).A().ak;
            this.getBlockRegistry().register(id, color);
        }
        this.getBlockRegistry().saveToDisk();
    }

    @Override
    protected void loadWorlds() {
        Bukkit.getWorlds().forEach(world -> this.getWorldRegistry().getOrDefault(world.getName(), () -> new BukkitWorld(((CraftWorld)world).getHandle(), world.getName())));
    }

    @Override
    protected void loadPlayers() {
        Bukkit.getOnlinePlayers().forEach(player -> {
            UUID uuid = player.getUniqueId();
            this.getPlayerRegistry().getOrDefault(uuid, () -> new BukkitPlayer((Player)player));
        });
    }

    @Override
    public World cloneWorld(World world) {
        return new BukkitWorld((WorldServer)world.getLevel(), world.getName());
    }
}

