/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.bukkit.command;

import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.command.Sender;
import net.pl3x.map.core.world.World;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class BukkitSender
extends Sender {
    public static Sender create(CommandSender sender) {
        if (sender instanceof org.bukkit.entity.Player) {
            return new Player(sender);
        }
        return new BukkitSender(sender);
    }

    public BukkitSender(CommandSender sender) {
        super(sender);
    }

    public CommandSender getSender() {
        return (CommandSender)super.getSender();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        BukkitSender other = (BukkitSender)o;
        return this.getSender() == other.getSender();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getSender());
    }

    @Override
    public String toString() {
        return "BukkitSender{sender=" + this.getSender().getName() + "}";
    }

    public static class Player
    extends BukkitSender
    implements Audience,
    Sender.Player<org.bukkit.entity.Player> {
        public Player(CommandSender sender) {
            super(sender);
        }

        @Override
        public org.bukkit.entity.Player getPlayer() {
            return (org.bukkit.entity.Player)this.getSender();
        }

        @Override
        public Audience audience() {
            return Pl3xMap.api().adventure().player(this.getPlayer().getUniqueId());
        }

        @Override
        public UUID getUUID() {
            return this.getPlayer().getUniqueId();
        }

        @Override
        public @Nullable World getWorld() {
            return (World)Pl3xMap.api().getWorldRegistry().get(this.getPlayer().getWorld().getName());
        }

        @Override
        public String toString() {
            return "BukkitSender$Player{player=" + String.valueOf(this.getPlayer().getUniqueId()) + "}";
        }
    }
}

