/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.command;

import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.configuration.Lang;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class Sender
implements ForwardingAudience.Single {
    private final Object sender;

    public <T> Sender(T sender) {
        this.sender = sender;
    }

    public <T> T getSender() {
        return (T)this.sender;
    }

    @Override
    public Audience audience() {
        return Pl3xMap.api().adventure().console();
    }

    public void sendMessage(String message) {
        this.sendMessage(message, true);
    }

    public void sendMessage(String message, boolean prefix) {
        if (!Lang.strip(message).isBlank()) {
            for (String part : message.split("\n")) {
                this.sendMessage(prefix, (ComponentLike)Lang.parse(part, new TagResolver.Single[0]));
            }
        }
    }

    public void sendMessage(String message, TagResolver.Single ... placeholders) {
        this.sendMessage(message, true, placeholders);
    }

    public void sendMessage(String message, boolean prefix, TagResolver.Single ... placeholders) {
        if (!Lang.strip(message).isBlank()) {
            for (String part : message.split("\n")) {
                this.sendMessage(prefix, (ComponentLike)Lang.parse(part, placeholders));
            }
        }
    }

    public void sendMessage(boolean prefix, ComponentLike message) {
        this.audience().sendMessage(prefix ? Lang.parse(Lang.PREFIX_COMMAND, new TagResolver.Single[0]).append(message) : message);
    }

    public abstract boolean equals(@Nullable Object var1);

    public abstract int hashCode();

    public abstract String toString();

    public static interface Player<T> {
        public T getPlayer();

        public UUID getUUID();

        public @Nullable World getWorld();
    }
}

