/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.command.commands;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.command.CommandHandler;
import net.pl3x.map.core.command.Pl3xMapCommand;
import net.pl3x.map.core.command.Sender;
import net.pl3x.map.core.command.parser.WorldParser;
import net.pl3x.map.core.configuration.Lang;
import net.pl3x.map.core.util.FileUtil;
import net.pl3x.map.core.world.World;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.minecraft.extras.RichDescription;
import org.incendo.cloud.processors.confirmation.ConfirmationManager;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ResetMapCommand
extends Pl3xMapCommand {
    public ResetMapCommand(CommandHandler handler) {
        super(handler);
    }

    @Override
    public void register() {
        this.getHandler().registerSubcommand(builder -> builder.literal("resetmap", new String[0]).required("world", WorldParser.parser(), (Description)ResetMapCommand.description(Lang.COMMAND_ARGUMENT_REQUIRED_WORLD_DESCRIPTION, new TagResolver.Single[0])).commandDescription(RichDescription.of(Lang.parse(Lang.COMMAND_RESETMAP_DESCRIPTION, new TagResolver.Single[0]))).meta(ConfirmationManager.META_CONFIRMATION_REQUIRED, true).permission("pl3xmap.command.resetmap").handler(this::execute));
    }

    private void execute(CommandContext<Sender> context) {
        CompletableFuture.runAsync(() -> this.executeAsync(context));
    }

    private void executeAsync(CommandContext<Sender> context) {
        Sender sender = context.sender();
        World world = (World)context.get("world");
        TagResolver.Single worldPlaceholder = Placeholder.unparsed("world", world.getName());
        sender.sendMessage(Lang.COMMAND_RESETMAP_BEGIN, worldPlaceholder);
        CompletableFuture.runAsync(() -> {
            String result;
            Pl3xMap.api().getWorldRegistry().unregister(world.getName());
            try {
                FileUtil.deleteDirectory(world.getTilesDirectory());
                result = Lang.COMMAND_RESETMAP_SUCCESS;
            }
            catch (IOException e) {
                result = Lang.COMMAND_RESETMAP_FAILED;
            }
            if (world.getPlayers().isEmpty()) {
                Pl3xMap.api().getWorldRegistry().register(Pl3xMap.api().cloneWorld(world));
            }
            sender.sendMessage(result, worldPlaceholder);
        });
    }
}

