/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.command.commands;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.pl3x.map.core.command.CommandHandler;
import net.pl3x.map.core.command.Pl3xMapCommand;
import net.pl3x.map.core.command.Sender;
import net.pl3x.map.core.command.parser.RendererParser;
import net.pl3x.map.core.command.parser.WorldParser;
import net.pl3x.map.core.command.parser.ZoomParser;
import net.pl3x.map.core.configuration.Config;
import net.pl3x.map.core.configuration.Lang;
import net.pl3x.map.core.image.io.IO;
import net.pl3x.map.core.log.Logger;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.renderer.Renderer;
import net.pl3x.map.core.world.World;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.minecraft.extras.RichDescription;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class StitchCommand
extends Pl3xMapCommand {
    public StitchCommand(CommandHandler handler) {
        super(handler);
    }

    @Override
    public void register() {
        this.getHandler().registerSubcommand(builder -> builder.literal("stitch", new String[0]).required("world", WorldParser.parser(), (Description)StitchCommand.description(Lang.COMMAND_ARGUMENT_REQUIRED_WORLD_DESCRIPTION, new TagResolver.Single[0])).required("renderer", RendererParser.parser(), (Description)StitchCommand.description(Lang.COMMAND_ARGUMENT_REQUIRED_RENDERER_DESCRIPTION, new TagResolver.Single[0])).optional("zoom", ZoomParser.parser(), (Description)StitchCommand.description(Lang.COMMAND_ARGUMENT_OPTIONAL_ZOOM_DESCRIPTION, new TagResolver.Single[0])).commandDescription(RichDescription.of(Lang.parse(Lang.COMMAND_STITCH_DESCRIPTION, new TagResolver.Single[0]))).permission("pl3xmap.command.stitch").handler(this::execute));
    }

    private void execute(CommandContext<Sender> context) {
        CompletableFuture.runAsync(() -> this.executeAsync(context));
    }

    private void executeAsync(CommandContext<Sender> context) {
        Sender sender = context.sender();
        World world = (World)context.get("world");
        Renderer.Builder renderer = (Renderer.Builder)context.get("renderer");
        int zoom = context.getOrDefault("zoom", Integer.valueOf(0));
        Path dir = world.getTilesDirectory().resolve(String.valueOf(zoom)).resolve(renderer.getKey());
        if (!Files.exists(dir, new LinkOption[0])) {
            sender.sendMessage(Lang.COMMAND_STITCH_MISSING_DIRECTORY);
            return;
        }
        Map<Point, Path> pngFiles = StitchCommand.getTiles(dir, sender);
        if (pngFiles == null) {
            return;
        }
        int minX = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (Point point : pngFiles.keySet()) {
            if (point.x() < minX) {
                minX = point.x();
            }
            if (point.x() > maxX) {
                maxX = point.x();
            }
            if (point.z() < minZ) {
                minZ = point.z();
            }
            if (point.z() <= maxZ) continue;
            maxZ = point.z();
        }
        int sizeX = maxX - minX;
        int sizeZ = maxZ - minZ;
        sender.sendMessage(Lang.COMMAND_STITCH_STARTING, Placeholder.unparsed("count", String.valueOf(pngFiles.size())), Placeholder.unparsed("min-x", String.valueOf(minX)), Placeholder.unparsed("min-z", String.valueOf(minZ)), Placeholder.unparsed("max-x", String.valueOf(maxX)), Placeholder.unparsed("max-z", String.valueOf(maxZ)), Placeholder.unparsed("size-x", String.valueOf(sizeX)), Placeholder.unparsed("size-z", String.valueOf(sizeZ)));
        String filename = StitchCommand.stitchImage(sizeX, sizeZ, pngFiles, minX, minZ, world, renderer, zoom);
        sender.sendMessage(Lang.COMMAND_STITCH_FINISHED, Placeholder.unparsed("count", String.valueOf(pngFiles.size())), Placeholder.unparsed("world", world.getName()), Placeholder.unparsed("renderer", renderer.getKey()), Placeholder.unparsed("filename", filename));
    }

    private static @Nullable Map<Point, Path> getTiles(Path dir, Sender sender) {
        HashMap<Point, Path> pngFiles = new HashMap<Point, Path>();
        try (Stream<Path> stream = Files.list(dir);){
            stream.filter(World.PNG_MATCHER::matches).forEach(path -> {
                int z;
                int x;
                String[] split = path.getFileName().toString().split(".png")[0].split("_");
                if (split.length != 2) {
                    return;
                }
                try {
                    x = Integer.parseInt(split[0]);
                    z = Integer.parseInt(split[1]);
                }
                catch (NumberFormatException e) {
                    return;
                }
                pngFiles.put(Point.of(x, z), (Path)path);
            });
        }
        catch (IOException e) {
            sender.sendMessage(Lang.COMMAND_STITCH_ERROR_READING_DIRECTORY);
            e.printStackTrace();
            return null;
        }
        if (pngFiles.isEmpty()) {
            sender.sendMessage(Lang.COMMAND_STITCH_EMPTY_DIRECTORY);
            return null;
        }
        return pngFiles;
    }

    private static String stitchImage(int sizeX, int sizeZ, Map<Point, Path> pngFiles, int minX, int minZ, World world, Renderer.Builder renderer, int zoom) {
        IO.Type io = IO.get(Config.WEB_TILE_FORMAT);
        BufferedImage stitched = new BufferedImage(sizeX + 1 << 9, sizeZ + 1 << 9, 2);
        Graphics2D g2d = stitched.createGraphics();
        for (Map.Entry<Point, Path> entry : pngFiles.entrySet()) {
            try {
                BufferedImage tile = io.read(entry.getValue());
                if (tile == null) continue;
                Point point = entry.getKey();
                g2d.drawImage((Image)tile, point.x() - minX << 9, point.z() - minZ << 9, null);
            }
            catch (Throwable t) {
                Logger.severe("Could not generate tile from point %s in path %s".formatted(entry.getKey(), entry.getValue().toAbsolutePath()), t);
            }
        }
        g2d.dispose();
        Path dir = world.getTilesDirectory().resolve("stitched");
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String filename = renderer.getKey() + "_" + zoom + "." + io.getKey();
        io.write(dir.resolve(filename), stitched);
        return filename;
    }
}

