/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.command.parser;

import java.util.stream.Collectors;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.command.exception.RendererParseException;
import net.pl3x.map.core.renderer.Renderer;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.ParserDescriptor;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class RendererParser<C>
implements ArgumentParser<C, Renderer.Builder>,
BlockingSuggestionProvider.Strings<C> {
    public static <C> ParserDescriptor<C, Renderer.Builder> parser() {
        return ParserDescriptor.of(new RendererParser<C>(), Renderer.Builder.class);
    }

    @Override
    public ArgumentParseResult<Renderer.Builder> parse(CommandContext<C> commandContext, CommandInput commandInput) {
        String input = commandInput.peekString();
        if (input == null) {
            return ArgumentParseResult.failure(new RendererParseException(null, RendererParseException.MUST_SPECIFY_RENDERER));
        }
        Renderer.Builder builder = (Renderer.Builder)Pl3xMap.api().getRendererRegistry().get(input);
        if (builder == null) {
            return ArgumentParseResult.failure(new RendererParseException(input, RendererParseException.NO_SUCH_RENDERER));
        }
        commandInput.readString();
        return ArgumentParseResult.success(builder);
    }

    @Override
    public Iterable<String> stringSuggestions(CommandContext<C> commandContext, CommandInput input) {
        return Pl3xMap.api().getRendererRegistry().values().stream().map(Keyed::getKey).filter(key -> !key.equals("blockinfo")).collect(Collectors.toList());
    }
}

