/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.configuration;

import java.nio.file.Path;
import libs.org.simpleyaml.configuration.file.YamlFile;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.configuration.AbstractConfig;
import net.pl3x.map.core.util.FileUtil;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class Config
extends AbstractConfig {
    @AbstractConfig.Key(value="settings.debug-mode")
    @AbstractConfig.Comment(value="Extra logger/console output. (can be spammy)")
    public static boolean DEBUG_MODE = false;
    @AbstractConfig.Key(value="settings.language-file")
    @AbstractConfig.Comment(value="The language file to use from the locale folder.")
    public static String LANGUAGE_FILE = "lang-en.yml";
    @AbstractConfig.Key(value="settings.web-address")
    @AbstractConfig.Comment(value="Set the web address players use to connect to your map. This\nis only used for the client mod to know where to connect.")
    public static String WEB_ADDRESS = "http://localhost:8080";
    @AbstractConfig.Key(value="settings.web-directory.path")
    @AbstractConfig.Comment(value="The directory that houses the website and world tiles.\nThis is a relative path from Pl3xMap's plugin directory,\nunless it starts with / in which case it will be treated\nas an absolute path.")
    public static String WEB_DIR = "web/";
    @AbstractConfig.Key(value="settings.web-directory.read-only")
    @AbstractConfig.Comment(value="Set to true if you don't want Pl3xMap to overwrite\nthe website files on startup. (Good for servers that\ncustomize these files)\nNote: Be sure this is false when upgrading.")
    public static boolean WEB_DIR_READONLY = false;
    @AbstractConfig.Key(value="settings.web-directory.tile-format")
    @AbstractConfig.Comment(value="The image format for tile images.\nBuilt in types: bmp, gif, jpg, jpeg, png")
    public static String WEB_TILE_FORMAT = "png";
    @AbstractConfig.Key(value="settings.web-directory.tile-quality")
    @AbstractConfig.Comment(value="The quality for image tiles (0.0 - 1.0)\n0.0 is low quality, high compression, small file size\n1.0 is high quality, no compression, large file size\nNote: Not all image formats honor this setting.")
    public static double WEB_TILE_QUALITY = 0.0;
    @AbstractConfig.Key(value="settings.map.zoom.snap")
    @AbstractConfig.Comment(value="Forces the map's zoom level to always be a multiple of this.\nBy default, the zoom level snaps to the nearest integer; lower\nvalues (e.g. 0.5 or 0.1) allow for greater granularity. A\nvalue of 0 means the zoom level will not be snapped.")
    public static double MAP_ZOOM_SNAP = 0.25;
    @AbstractConfig.Key(value="settings.map.zoom.delta")
    @AbstractConfig.Comment(value="Controls how much the map's zoom level will change after a zoom in,\nzoom out, pressing + or - on the keyboard, or using the zoom controls.\nValues smaller than 1 (e.g. 0.5) allow for greater granularity.")
    public static double MAP_ZOOM_DELTA = 0.25;
    @AbstractConfig.Key(value="settings.map.zoom.wheel")
    @AbstractConfig.Comment(value="How many scroll pixels (as reported by L.DomEvent.getWheelDelta) mean\na change of one full zoom level. Smaller values will make wheel-zooming\nfaster (and vice versa).")
    public static int MAP_ZOOM_WHEEL = 120;
    @AbstractConfig.Key(value="settings.internal-webserver.enabled")
    @AbstractConfig.Comment(value="Enable the built-in web server.\nDisable this if you want to use a standalone web server\nsuch as apache or nginx.")
    public static boolean HTTPD_ENABLED = true;
    @AbstractConfig.Key(value="settings.internal-webserver.bind")
    @AbstractConfig.Comment(value="The interface the built-in web server should bind to.\nThis is NOT always the same as your public facing IP.\nIf you don't understand what this is,\nleave it set to 0.0.0.0")
    public static String HTTPD_BIND = "0.0.0.0";
    @AbstractConfig.Key(value="settings.internal-webserver.port")
    @AbstractConfig.Comment(value="The port the built-in web server listens to.\nMake sure the port is allocated if using Pterodactyl.")
    public static int HTTPD_PORT = 8080;
    @AbstractConfig.Key(value="settings.internal-webserver.follow-symlinks")
    @AbstractConfig.Comment(value="Allows the built-in web server to follow symlinks.\nIt is generally advised against enabling this,\nfor security reasons. But you do you, boo boo.")
    public static boolean HTTPD_FOLLOW_SYMLINKS = false;
    @AbstractConfig.Key(value="settings.performance.live-update.enabled")
    @AbstractConfig.Comment(value="Whether or not the real-time marker system should run.")
    public static boolean LIVE_UPDATE_ENABLED = true;
    @AbstractConfig.Key(value="settings.performance.live-update.threads")
    @AbstractConfig.Comment(value="The number of process-threads to use for real-time marker updates on the map.\nValue of -1 will use 50% of the available cpu-threads. (recommended)")
    public static int LIVE_UPDATE_THREADS = -1;
    @AbstractConfig.Key(value="settings.performance.render-threads")
    @AbstractConfig.Comment(value="The number of process-threads to use for loading and scanning chunks.\nValue of -1 will use 50% of the available cpu-threads. (recommended)")
    public static int RENDER_THREADS = -1;
    @AbstractConfig.Key(value="settings.performance.gc.when-finished")
    @AbstractConfig.Comment(value="Runs the JVM GC after a render job stops to free up memory immediately.")
    public static boolean GC_WHEN_FINISHED = true;
    @AbstractConfig.Key(value="settings.performance.gc.when-running")
    @AbstractConfig.Comment(value="Runs the JVM GC aggressively while a render is running\nCAUTION: this _will_ slow down your renders!")
    public static boolean GC_WHEN_RUNNING = false;
    private static final Config CONFIG = new Config();

    public static void reload() {
        Path mainDir = Pl3xMap.api().getMainDir();
        FileUtil.extractFile(Config.class, "config.yml", mainDir, false);
        CONFIG.reload(mainDir.resolve("config.yml"), Config.class);
        if (!Pl3xMap.api().isBukkit()) {
            Config.tryRenamePath("world-settings.world", "world-settings.minecraft:overworld");
            Config.tryRenamePath("world-settings.world_nether", "world-settings.minecraft:the_nether");
            Config.tryRenamePath("world-settings.world_the_end", "world-settings.minecraft:the_end");
        }
    }

    private static void tryRenamePath(String oldPath, String newPath) {
        YamlFile config = CONFIG.getConfig();
        Object oldValue = config.get(oldPath);
        if (oldValue == null) {
            return;
        }
        if (config.get(newPath) != null) {
            return;
        }
        config.set(newPath, oldValue);
        config.set(oldPath, null);
        CONFIG.save();
    }
}

